#include "gfm.ch"
#define LOOKUP_KEY 1
#define HELP_TITLE 2

/////////////////
/////////////////
//
//     Purpose:
//      Menu-specific notes in a GrumpMenu System
//
//      Syntax:
//      GFMNotes( <cProcedure>, <nLine>, <cVariable> )
//
//   Formal Arguments:
//      Name        Description
//       
//      cProcedure  Calling procedure (standard in a hot-key)
//      nLine       Calling procedure line (standard in a hot-key)
//      cVariable   Current read variable (standard in a hot-key)
//
//     Returns:
//      .t.
//
//     Example:
//      set key -29 to gfmnotes()
//
//       Files:
//      None.
//
// Description:
//      Calls the note-taking function available in the GrumpMenu library
//
//       Notes:
//
//
//    Category:
//      Menu Handling
//
//    See Also:
//
//
/////////////////
/////////////////
FUNCTION GFMNotes( cProcedure, nLine, cVariable )
	LOCAL cAction := 'E'
	LOCAL lRekey  := GFMSet( _GFM_STYLE ) $ 'PNS' .AND. GFMSet( _GFM_LEVEL ) == 1
	LOCAL GFMHelpKey := GFMHelpKey()	// Get the help key settings
	LOCAL bNoteKey := SetKey( GFMSet( _GFM_NOTEKEY ) )

	IF GFMHelpKey == NIL .OR. Len( GFMHelpKey ) == 0 .OR. Empty( GFMHelpKey )
		RETURN .t.
	ENDIF

	IF lRekey THEN GFMKeyOff( GFMSet( _GFM_STYLE ) )	// Pulling down menus?

	Set Key GFMSet( _GFM_NOTEKEY ) to	// Clearing the Notes key for now
	Not8( cAction, GFMHelpKey[ LOOKUP_KEY ],, GFMHelpKey[ HELP_TITLE ] )

	IF lRekey THEN GFMKeyOn( GFMSet( _GFM_STYLE ) )
	SetKey( GFMSet( _GFM_NOTEKEY ), bNoteKey )

RETURN .t.


