#include "gfm.ch"

//////////////////
//////////////////
//
//	Section:
//		
//
//	Category:
//		Menu Handling
//
//	Purpose:
//    Read key from Keyboard with a wait state
//
//	Syntax:
//		GFMGetKey( <nSeconds>, <nKey> ) -> nKey
//
//	Formal Arguments: (2)
//		Name       	Description
//			
//		nSeconds  	Seconds to delay
//		nKey      	Key to process.  Defaults to InKey()
//
//	Returns:
//		Key that was pressed
//
//	Examples:
//
//
//	Files:
//		
//
//	Description:
//		Basically, an Inkey() replacement for using in wait states, with
//		one additional parameter.
//
//	Notes:
//		
//
//	See Also:
//
//
//	Include files:
//		gfm.ch
//
//	Revisions:
//		04/12/93	14:42:42	1.0	Original version
//
//////////////////
//////////////////
FUNCTION GFMGetKey( nSeconds, nKey )
   LOCAL bKeyBlock, aLevel
   DO WHILE .T.
      IF nKey == NIL
         nKey := InKey( nSeconds )
      ENDIF
      IF ( aLevel := GFMHotKey( nKey ) ) # NIL
			GFMGotoMain()
         GFMForce( aLevel )            	// Go to hot key option
         EXIT
      ELSEIF ( bKeyBlock := SetKey( nKey ) ) <> NIL
         Eval( bKeyBlock, ProcName(2), ProcLine(2), "" )
      ELSE
         EXIT
      ENDIF
      nKey := NIL
   ENDDO
RETURN nKey

