#include "gfm.ch"

STATIC aHotKeys := {}, aForce := {}

FUNCTION GFMHotPush( aHotKey )
   LOCAL nScan := aScan( aHotKeys, ;
      {|keydef| keydef[ _GFM_HOTKEY ] == aHotKey[ _GFM_HOTKEY ] } )
   IF nScan == 0  // Not found - it can be added w/o duplication
      aAdd( aHotKeys, aHotKey )
   ENDIF
RETURN Len( aHotKeys )

FUNCTION GFMHotPop( nKey )
   LOCAL nPos := 0
   IF nKey # NIL
      IF ( nPos := aScan( aHotKeys, {|keydef| keydef[ _GFM_HOTKEY ] == nKey } ) ) > 0
         aDel( aHotKeys, nPos )
         aHotKeys := aSize( aHotKeys, Len( aHotKeys ) - 1 )
      ENDIF
   ENDIF
RETURN Len( aHotKeys )

FUNCTION GFMHotKey( nKey )
   LOCAL nPos := 0
   LOCAL aReturn := NIL
   IF nKey # NIL
      IF ( nPos := aScan( aHotKeys, {|key| key[ _GFM_HOTKEY ] == nKey } ) ) > 0
         aReturn := aHotKeys[ nPos, _GFM_HOTLEVEL ]
      ENDIF
   ENDIF
RETURN aReturn

FUNCTION GFMHotNew( cPrompt, nKey, aMenuLev )
RETURN { cPrompt, nKey, aMenuLev }

FUNCTION GFMHotWipe // Clear all hot key definitions
   LOCAL aOld := aClone( aHotKeys )
   aHotKeys := {}
RETURN aOld

FUNCTION GFMToMainArray( nStay )
   LOCAL aLevel := {}
   DEFAULT nStay TO 0
	IF GFMSet( _GFM_LEVEL ) > 0
	   aLevel := Array( GFMSet( _GFM_LEVEL ) - nStay )
	   aEval( aLevel, { | a, n | aLevel[n] := 0 } )
	ENDIF
RETURN aLevel

FUNCTION GFMGotoMain( nStay )
RETURN GFMForce( GFMToMainArray( nStay ) )

FUNCTION GFMForceList
RETURN aForce

FUNCTION GFMForce( aMenuLev )
   LOCAL anLevel := {}
   LOCAL nReturn := NIL
   IF aMenuLev # NIL .AND. ValType( aMenuLev ) == 'A'
      // Insert these menu choice forcing values into aForce static array
      aEval( aReverse( aMenuLev ), { | a | aAdd( anLevel, a ) } )
      aEval( aForce, { | a | aAdd( anLevel, a ) } )
      aForce := NoNils( anLevel )
   ELSEIF ( anLevel := Len( aForce ) ) > 0
      nReturn := aForce[ anLevel ]
      aForce := aSize( aForce, --anLevel )
   ENDIF
RETURN nReturn

STATIC FUNCTION NoNils( aArray )
	LOCAL aReturn := {}
	LOCAL bStripBlock
	IF GFMSet( _GFM_LEVEL ) > 0
		bStripBlock := { |a| a # NIL .AND. aAdd( aReturn, a ) # NIL }
	ELSE
		bStripBlock := { |a| a # NIL .AND. a # 0 .AND. aAdd( aReturn, a ) # NIL }
	ENDIF
	aEval( aArray, bStripBlock )
RETURN aReturn

STATIC FUNCTION aReverse( aArray )
   LOCAL nPos := Len( aArray )
   LOCAL aNew := Array( nPos )
   aEval( aArray, { | a | aNew[ nPos-- ] := a } )
RETURN aNew

FUNCTION GFMExit( lSet )
   STATIC lExiting := .F.
   IF lSet # NIL
      lExiting := lSet
   ENDIF
RETURN lExiting

FUNCTION GFMForceNext
	LOCAL nReturn := -1
	IF Len( aForce ) > 0 THEN nReturn := aTail( aForce )
RETURN nReturn
