// re-compile using the /n switch
#include "gfm.ch"
#include "inkey.ch"
#define ENTRY_LENGTH 72

// Generation string information the user may enter
STATIC UserName    := "<Your Name>"
STATIC CopyRight   := "<Your Copyright Notice>"
STATIC GFMHello    := ""
STATIC GFMGoodbye  := ""
STATIC Trace       := "DON'T TRACE"
STATIC aTrace      := { "DON'T TRACE", "TRACE" }
STATIC Prototype   := "DON'T PROTOTYPE"
STATIC aProtoType  := { "PROTOTYPE", "DON'T PROTOTYPE" }
STATIC SaveScreen  := "DON'T SAVE SCREENS"
STATIC aSaveScreen := { "SAVE SCREENS", "DON'T SAVE" }
STATIC Escape      := "ESCAPE"
STATIC aEscape     := { "ESCAPE", "NO ESCAPE!" }
STATIC Positions   := "SAVE POSITIONS"
STATIC aPositions  := { "SAVE POSITIONS", "DON'T SAVE POSITIONS" }
STATIC GFMSysScr   := "RESTORE"
STATIC aGFMSysScr  := { "RESTORE", "DON'T RESTORE" }
STATIC GFMDraw     := "DRAW BACKGROUND"
STATIC aGFMDraw    := { "DRAW", "DON'T DRAW" }
STATIC TSRKey      := "NO TSR"
STATIC aTSRKey     := { "NO TSR","TSR" }
STATIC CodeIndent  := 2

/////////////////
/////////////////
//
//  Purpose:  Write the GrumpFish Menu .CFG file
//
//   Syntax:  GFMcfgwt( <cFileName> )
//
//   Parameters:
//
//      Name        Description
//       
//      cFileName   Name of configuration file to save to
//      nDelay      Number of seconds to delay after writing
//
//  Returns:  .t.
//
//  Example:  GFMcfgwt( "grumpmen.cfg" )
//
//    Files:  None.
//
// Overview:  Writes the configuration settings for GrumpMenu to the
//            specified file.  Works for BOTH the Run-time and the
//            generation-time configuration information.  Checks the
//            staus of GFMInstall() to determine if this is the installation
//            program.
//
//    Notes:
//
// Category:   Menu Handling
//
// See Also:
//
/////////////////
/////////////////
FUNCTION GFMcfgwt( cFileName, nDelay )
   LOCAL nFh, nR1 := -1, nC1 := -1, nR2 := -1, nC2 := -1
   LOCAL nPos, aSets := GFMSet(), nWidth := 0
   LOCAL GetList := {}
	LOCAL bHelpKey := SetKey( K_F1 )

   IF cFileName == NIL THEN RETURN .F.

   IF File( cFileName )
      w_error( setcolor(), 0, ;
         "Press [Esc] to abort saving, any other key to overwrite", ;
         trim( cFileName ) + ' exists!', "Press [Esc] or other key now" )
      IF LastKey() == 27
         RETURN .f.
      ENDIF
   ENDIF

	IF ( nFh := fcreate( Trim( cFileName ) ) ) < 0
		w_error( setcolor(), 0, "Could not open " + Trim( cFileName ) +"~for writing!", ;
					"Unable to save configuration information!", "Press a key to return" )
	ELSE
	   w_Push()	// Save the current screen

		CLS
		? "Writing new defaults:"
		?

		IF GFMSet( _GFM_INSTALL )

			DEFAULT nDelay TO 5

			// Allowing editing room for these bad boys
			UserName    := PadR( UserName, ENTRY_LENGTH )
			CopyRight   := PadR( CopyRight, ENTRY_LENGTH )
			GFMHello    := PadR( GFMHello, ENTRY_LENGTH )
			GFMGoodbye  := PadR( GFMGoodbye, ENTRY_LENGTH )

			// Scale the window for the input size
			w_scale( 16, 70, @nR1, @nC1, @nR2, @nC2 )
			w_shade( nR1, nC1, nR2, nC2, frame(1), ;
			        'GrumpFish Menu Code Generation Options', ;
			        'Only available in Install Program' )
			@ ++nR1, ++nC1 say 'These options only affect generated code'
			nR1++

			Set Key K_F1 TO DoValid
			@ ++nR1, nC1 say 'Programmer Name      = ' get UserName pict '@S35'
			@ ++nR1, nC1 say 'Copyright notice     = ' get CopyRight pict '@S35'
			@ ++nR1, nC1 say 'Code indenting       = ' get CodeIndent
			@ ++nR1, nC1 say 'Hello FUNCTION       = ' get GFMHello pict '@S35'
			@ ++nR1, nC1 say 'Goodbye FUNCTION     = ' get GFMGoodbye pict '@S35'
			@ ++nR1, nC1 say 'Prototype system     = ' get Prototype ;
			  valid PickList( @Prototype, aPrototype,, 'Prototype System' )
			@ ++nR1, nC1 say 'Escape main menu     = ' get Escape ;
			  valid PickList( @Escape, aEscape,, 'Escape option' )
			@ ++nR1, nC1 say 'Trace calls          = ' get Trace ;
			  valid PickList( @Trace, aTrace,, 'Tracing calls' )
			@ ++nR1, nC1 say 'Save screens         = ' get SaveScreen ;
			  valid PickList( @Savescreen, aSavescreen,, 'Save Screens' )
			@ ++nR1, nC1 say 'Position saving      = ' get Positions ;
			  valid PickList( @Positions, aPositions,, 'Positions option' )
			@ ++nR1, nC1 say 'Restore Screen       = ' get GFMSysScr ;
			  valid PickList( @GFMSysScr, aGFMSysScr,, 'Restore DOS screen' )
			@ ++nR1, nC1 say 'Draw Background      = ' get GFMDraw ;
			  valid PickList( @GFMDraw, aGFMDraw,, 'Draw Background Screen' )
			@ ++nR1, nC1 say 'TSR key can be used  = ' get TSRKey ;
			  valid PickList( @TSRKey, aTSRKey,, 'TSR Key (Dr. Switch support)' )
			read
			SetKey( K_F1, bHelpKey )

			fdisplay( nFh, 'Name                 = ' + Trim( UserName   ) )
			fdisplay( nFh, 'Copyright            = ' + Trim( CopyRight  ) )
			fdisplay( nFh, 'Trace                = ' + Trim( Trace      ) )
			fdisplay( nFh, 'Prototype            = ' + Trim( Prototype  ) )
			fdisplay( nFh, 'Save screens         = ' + Trim( SaveScreen ) )
			fdisplay( nFh, 'Escape main menu     = ' + Trim( Escape     ) )
			fdisplay( nFh, 'Position saving      = ' + Trim( Positions  ) )
			fdisplay( nFh, 'Code indenting       = ' + Ltrim( str( CodeIndent ) ) )
			fdisplay( nFh, 'Hello                = ' + Trim( GFMHello   ) )
			fdisplay( nFh, 'Goodbye              = ' + Trim( GFMGoodbye ) )
			fdisplay( nFh, 'Restore Screen       = ' + Trim( GFMSysScr  ) )
			fdisplay( nFh, 'Draw Background      = ' + Trim( GFMDraw    ) )
			fdisplay( nFh, 'TSR key              = ' + Trim( TSRKey ) )

		ENDIF

		aEval( aSets, { | aSet, nPos | fDisplay( nFh, PadR( aSet[ _GFM_PROMPT ], ;
				_GFM_PROMPT_WIDTH ) + '= ' + GFMString( aSet[ _GFM_VALUE ], nPos ) ) }, ;
				1, _GFM_RUN_COUNT )

		// Saving Size information
		aEval( GFMSizeStack(), { | a | fWriteLine( nFh, GFMSizeString( a ) ) } )
		fClose( nFh )

		IF nDelay # NIL THEN InKey( nDelay )

		w_Pop()
   ENDIF

RETURN .t.

// Return the correct text based on field type and SET position
FUNCTION GFMString( uValue, nPos )
   LOCAL cString := '', cType, cReturn := uValue
   DO CASE
   CASE nPos == _GFM_BACKCHAR .AND. ( cType := ValType( uValue ) ) == 'C'
     cReturn := LTrim( Str( Asc( uValue ) ) )
   CASE ValType( uValue ) == 'L'
      IF nPos == _GFM_BRIGHT
        cReturn := IIF( uValue, 'BRIGHT','BLINK' )
      ELSE
        cReturn := IIF( uValue, 'WRAPPING','NO WRAPPING' )
      ENDIF
   CASE ValType( uValue ) == 'N' ; cReturn := Ltrim( Str( uValue ) )
   ENDCASE
RETURN LTrim( Trim( cReturn ) )

/////////////////
/////////////////
//
//  Purpose:  Read in GrumpFish Menu configuration settings
//
//   Syntax:  GFMcfgrd( <cFileName> )
//
//   Parameters:
//
//      Name        Description
//       
//      cFileName   Name of configuration file to read
//
//  Returns:  an array of GFM settings that are contained in the CFG file
//
//  Example:  GFMcfgrd( "grumpmen.cfg" )
//
//    Files:  <cFileName>
//
// Overview:
//      Function to read in configuration information
//
//    Notes:
//
//
// Category:
//      Menu Handling
//
// See Also:
//
/////////////////
/////////////////
FUNCTION GFMcfgrd( cFileName )
   LOCAL nFh, cLine := '', nEqual, cAssign, cUpLine
   IF cFileName == NIL
      RETURN NIL
   ENDIF
	IF ( ! File( cFileName ) ) .AND. At(".", cFileName ) == 0
		cFileName += ".CFG"
	ENDIF

   IF ( nFh := fopen( Trim( cFileName ) ) ) > 0

      DO WHILE fReadLn( nFh, @cLine, 255 )
         // Configuration lines better be 255 chars or less, or tough!
         cUpLine := Upper( cLine := AllTrim( cLine ) )
         IF ( nEqual := at( '=', cLine ) + 1 ) == 0
            LOOP
         ENDIF

         cAssign := Ltrim( SubStr( cLine, nEqual, 255 ) )

         DO CASE
         CASE At('NAME', cUpLine ) == 1; UserName := cAssign
         CASE At('COPY', cUpLine ) == 1; CopyRight := cAssign
         CASE At( 'TRAC', cUpLine ) == 1; Trace := Upper( cAssign )
         CASE At( 'MENU', cUpLine ) == 1; GFMSet( _GFM_MENUCOLOR, Upper( cAssign ) )
         CASE At( 'FRAM', cUpLine ) == 1; GFMSet( _GFM_FRAMECOLOR, Upper( cAssign ) )
         CASE At( 'BACKGROUND CO', cUpLine ) == 1; GFMSet( _GFM_BACKCOLOR, Upper( cAssign ) )
         CASE At( 'BACKGROUND CHAR', cUpLine ) == 1
            IF SubStr( cAssign, 1, 1 ) $ '0123456789'
              GFMSet( _GFM_BACKCHAR, Chr( Val( cAssign ) ) )
            ELSE
              GFMSet( _GFM_BACKCHAR, SubStr( cAssign, 1, 1 ) )
            ENDIF
         CASE At( 'SHAD', cUpLine ) == 1; GFMSet( _GFM_SHADE, SubStr( cAssign + '21', 1, 3 ) )
         CASE At( 'PROT', cUpLine ) == 1; Prototype := Upper( cAssign )
         CASE At( 'TOP', cUpLine ) == 1; GFMSet( _GFM_TOPLINE, val( cAssign ) )
         CASE At( 'LEFT', cUpLine ) == 1; GFMSet( _GFM_LEFTCOL, val( cAssign ) )
         CASE At( 'RIGH', cUpLine ) == 1; GFMSet( _GFM_RIGHTCOL, val( cAssign ) )
         CASE At( 'SPAC', cUpLine ) == 1; GFMSet( _GFM_SPACING, val( cAssign ) )
         CASE At( 'INDE', cUpLine ) == 1; GFMSet( _GFM_INDENT, val( cAssign ) )
         CASE At( 'SAVE', cUpLine ) == 1; SaveScreen := Upper( cAssign )
         CASE At( 'STYL', cUpLine ) == 1; GFMSet( _GFM_STYLE, Upper( cAssign ) )
         CASE At( 'POSI', cUpLine ) == 1; Positions := Upper( cAssign )
         CASE At( 'FOOT', cUpLine ) == 1; GFMSet( _GFM_FOOTER, cAssign )
         CASE At( 'TITL', cUpLine ) == 1; GFMSet( _GFM_TITLE, cAssign )
         CASE At( 'GOOD', cUpLine ) == 1; GFMGoodbye := cAssign
         CASE At( 'HELL', cUpLine ) == 1; GFMHello := cAssign
         CASE At( 'REST', cUpLine ) == 1; GFMSysScr := Upper( cAssign )
         CASE At( 'DRAW', cUpLine ) == 1; GFMDraw := Upper( cAssign )
         CASE At( 'CONF', cUpLine ) == 1; GFMSet( _GFM_CFGKEY, KeyVal( cAssign ) )
         CASE At( 'CODE', cUpLine ) == 1; CodeIndent := val( cAssign )
         CASE At( 'UTIL', cUpLine ) == 1; GFMSET( _GFM_UTILKEY, KeyVal( cAssign ) )
         CASE At( 'ESCA', cUpLine ) == 1; Escape := Upper( cAssign )
         CASE At( 'TSR', cUpLine ) == 1; TSRKey := Upper( cAssign )
         CASE At( 'NOTE', cUpLine ) == 1; GFMSet( _GFM_NOTEKEY, KeyVal( cAssign ) )
         CASE At( 'BRIG', cUpLine ) == 1; GFMSet( _GFM_BRIGHT, ( At('BRIG', Upper( cAssign ) ) == 1 ) )
         CASE At( 'WRAP', cUpLine ) == 1; GFMSet( _GFM_WRAP, ( At('WRAP', Upper( cAssign ) ) == 1 ) )
         ENDCASE

      ENDDO

      fClose( nFh )

   ENDIF

	GFMSizeRead( cFileName )

RETURN .T.

STATIC FUNCTION KeyVal( cKey )
	LOCAL nKey := Val( cKey := AllTrim( cKey ) )
	IF AllTrim( Str( nKey ) ) # cKey
		nKey := InKeyLookup( cKey )
	ENDIF
RETURN nKey

#include "fileio.ch"

STATIC FUNCTION InKeyLookUp( cKey )
	LOCAL nKey			:= 0
	LOCAL cInkeyFile	:= PathFindFile( GetE( "INCLUDE" ), "INKEY.CH" )
	LOCAL nFh 			:= fOpen( cInKeyFile, FO_READ + FO_SHARED )
	IF nFh > -1
		cKey := Upper( AllTrim( cKey ) )
		IF At( 'K_', cKey ) # 1 THEN cKey := "K_" + StrTran( cKey, '-', '_' )
		IF fLocate( nFh, "#DEFINE " + cKey, 'U' ) > -1
			nKey := Val( StrExtract( Compact( fReadLine( nFh ) ), ' ', 3 ) )
		ENDIF
		fClose( nFh )
	ENDIF
RETURN nKey

/////////////////
/////////////////
//
//  Purpose:  Write something to file <nFh> while displaying it
//
//   Syntax:  fdisplay( <nFh>, <txt> )
//
//   Parameters:
//
//      Name        Description
//       
//      nFh         DOS File handle
//      txt         Text to write
//
//  Returns:  .t. IF successful
//
//  Example:  fdisplay( filehandle, Trim( CopyRight ) )
//
//    Files:  File attached to handle <nFh>
//
// Overview:
//
//    Notes:
//
// Category:
//
// See Also:
//
/////////////////
/////////////////
STATIC FUNCTION fdisplay( nFh, cText )
   QOut( cText )
RETURN fWrite( nFh, cText + chr(13) + chr(10) ) == len( cText ) + 2

#xtrans AssignGet( <v> ) => Get:varPut(<v>);Get:updateBuffer();Get:display()
#define POINT_RIGHT Chr(16)
#define POINT_LEFT  Chr(17)

STATIC PROCEDURE DoValid()
	LOCAL Get := GetActive()
	IF !Empty( Get:postBlock ) .AND. ValType( Get:postBlock ) == 'B'
		Eval( Get:postBlock )
	ENDIF
RETURN

STATIC FUNCTION GivePicks( Get )
	LOCAL lGive := LastKey() == K_F1 .AND. Get # NIL
	IF lGive
		Point2Get()
	ENDIF
RETURN lGive

STATIC FUNCTION Point2Get()
	STATIC cScreen1, cScreen2
   LOCAL Get 		:= GetActive()
   LOCAL nLength  := Len( Trans( Get:varGet(), ;
									IIF( Empty( Get:picture ), "@X", Get:picture ) ) )
   LOCAL nFront   := Get:col - Len( POINT_RIGHT )
   LOCAL nBack    := Get:col + nLength

	IF cScreen1 == NIL // Toggle the pointer on
		cScreen1 := SaveScreen( Get:row, nFront, Get:row, Get:col )
		cScreen2 := SaveScreen( Get:row, nBack, Get:row, nBack + Len( POINT_LEFT ) )
   	@ Get:row, nFront SAY POINT_RIGHT
   	@ Get:row, nBack SAY POINT_LEFT
	ELSE
	   RestScreen( Get:row, nFront, Get:row, Get:col, cScreen1 )
	   RestScreen( Get:row, nBack, Get:row, nBack + Len( POINT_LEFT ), cScreen2 )
		cScreen1 := cScreen2 := NIL
	ENDIF
RETURN cScreen1 == NIL


//////////////
//////////////
//
//  Purpose:  Validate input
//
//   Syntax:  PickList( @<entry>, <acList>, <cDelim>, <cPrompt> )
//
//   Parameters:
//
//      Name        Description
//       
//      entry       Value that was entered
//      acList      List of possible values
//      cDelim      Delimiting character for list - defaults to ','
//      cPrompt     Prompt for the box
//
//  Returns:  .t.
//
//  Example:
//
//    Files:  None.
//
// Overview:
//
//    Notes:
//
// Category:
//      Menu Handling
//
// See Also:
//
//////////////
//////////////
STATIC FUNCTION PickList( cEntry, acList, cDelim, cPrompt )
   LOCAL aChoices := {}, nResponse := 0, nWidth
   LOCAL Get := GetActive(), lOK := .t.
   IF acList == NIL .OR. cEntry == NIL
      RETURN lOK
   ENDIF

	IF GivePicks( Get )
   	DEFAULT cDelim TO ",", cPrompt TO 'Choices'

   	IF ValType( acList ) == 'C'
   	   aChoices := DelimToA( acList, cDelim )
   	ELSE
   	   aChoices := acList	// It's an array already.
   	ENDIF

		// Pad them to the correct length
		nWidth := Max( aMaxStrLen( aChoices ), Len( get:buffer ) )
  	   aEval( aChoices, { | c, n | aChoices[ n ] := PadR( c, nWidth ) } )
		Point2Get()
   	IF ( nResponse := PopChoice( aChoices, cPrompt, "  Esc",,,,,,,;
   	      aScan( aChoices, cEntry ) ) ) # 0
   	   cEntry := aChoices[ nResponse ]
   	   AssignGet( cEntry )
   	ENDIF
	ENDIF
RETURN lOK
