#include "gfm.ch"
***************
***************
**
**  Purpose:  Make the current clipper application a TSR program
**
**   Syntax:  GFMTsr( <cProc>, <nLine>, <cVariable> )
**
**   Parameters:
**
**      Name        Description
**       
**      cProc       Procedure that was hot-keyed from
**      nLine       Line number in procedure
**      cVariable   Input variable
**
**  Returns:  .t.
**
**  Example:  GFMTsr()
**
**    Files:  None.
**
** Overview:  Calls Dr. Switch ASE's functions to swap your Clipper application
**            with another application, making your Clipper application a GFMTSR
**
**    Notes:  Just exit to the DOS prompt.
**            Swap to a network drive.
**            Free the maximum amount of RAM.
**            Use the same key to suspend Clipper and whatever may be running.
**            Use any memory resource that's available.
**            No timeout is necessary, go to DOS and wait.
**
** Category:  Menu Handling
**
** See Also:  GFMTSRAsk() GFMTSRExit()
**
***************
***************
FUNCTION GFMTsr( cProc, nLine, cVariable )
	LOCAL cKeyStuff := '', cPath := ""
	LOCAL nRam := 640, cHotKey := "{ALT}"+alt( GFMTSRKey() )
	LOCAL lEMSUsage := .t., lXMSUsage := .t., lWarmBoot := .T.
	DRNewRes(.F.)	// Goes resident w/ command.com
	DRSwapDos(.T.)	// Force DOS Swapping
	IF DRActive()
	  @ maxrow(), 0
	  @ maxrow(), 0 say 'Returning to suspended application . . .'
	  // Go back to what we popped up on
	  drswap()
	  @ maxrow(), 0
	ELSE
	  // Turn the current application into a TSR
	  set key GFMTSRKey() to GFMTsr
	  w_Push()
	  cls
	  ? 'Press ' + cHotKey + ' to suspend this DOS session and re-enter the program'
	  ? 'Type "EXIT" and press [Enter] from the DOS prompt to return to the program'
	  ? 'without preserving this DOS session (unloading this session)'
	  nRam := drload( cKeyStuff, cPath, nRam, cHotKey, lEMSUsage, lXMSUsage, ;
	          			lWarmBoot )
	  w_Pop()
	ENDIF
RETURN .t.


******************
******************
**
**  Purpose:  Ask if the user wants this application loaded as a TSR
**
**   Syntax:  GFMTSRAsk()
**
**  No panRameters specified
**
**  Returns:  .t. if the user wants this application loaded as a TSR, .f. 
**            otherwise
**
**  Example:  GFMTSRAsk()
**
**    Files:  None.
**
** Overview:  Ask the user whether or not he/she wants this loaded as a TSR
**
**    Notes:  
**
** Category:  Menu Handling
**
** See Also:  GFMTSRExit()  GFMTsr()
**
******************
******************
function GFMTSRAsk
w_error( setcolor(), 0, 'Press an [Alt] key combination to make this a TSR', ;
         'This application can remain in memory while you run others!', ;
         'Press an [Alt] key or any other key now.' )
GFMTSRKey( lastkey() )
if len( alt( GFMTSRKey() ) ) > 0  && A recognized Alt-Key was pressed
  GFMTsr()
endif
return .t.

*******************
*******************
**
**  Purpose:  Exit the current program, but check if an app is suspended first
**
**   Syntax:  GFMTSRExit()
**
**  No panRameters specified
**
**  Returns:  .t. if no application is suspended, .f. otherwise
**
**  Example:  if ! GFMTSRExit()
**              return .f.
**            endif
**
**    Files:  None.
**
** Overview:  Uses Dr. Switch function dractive() to see if there is a suspended
**            application.  If there is, it requires the user to go to that 
**            app to terminate it.
**
**    Notes:  
**
** Category:  Menu Handling
**
** See Also:  GFMTSRAsk() GFMTsr()
**
*******************
*******************
function GFMTSRExit

if dractive()
  w_error( setcolor(), 0, ;
          'Please terminate the suspended program now!~' + ;
          'Otherwise, your system may hang up!', ;
          'Trying to exit the current program, but another one is active!', ;
          'Press a key to continue' )
  GFMTsr()
endif

if dractive()
  w_error( setcolor(), 10, 'The suspended program was not terminated', ;
          'Unable to quit this application!', 'Press a key to return' )
  return .f.
endif

return .t.

FUNCTION GFMTSRKey( nNewKey )
	STATIC nKey := 0
	IF PCOUNT() > 0
		nKey := nNewKey
	ENDIF
RETURN nKey
