/*
File: GFM.CH
Author: John F. Kaster
Notes:	GrumpFish Menu Clipper Header file
*/

#define GFM_VERSION 'GRUMPFISH(tm) MENU Version 2.5'

#define _GFM_SET
// Run-time configurable settings
#define _GFM_MENUCOLOR			1
#define _GFM_FRAMECOLOR			2
#define _GFM_BACKCOLOR			3
#define _GFM_BACKCHAR			4
#define _GFM_SHADE				5
#define _GFM_TOPLINE				6
#define _GFM_STYLE				7
#define _GFM_LEFTCOL				8
#define _GFM_RIGHTCOL			9
#define _GFM_INDENT				10
#define _GFM_NOTEKEY				11
#define _GFM_CFGKEY				12
#define _GFM_UTILKEY				13
#define _GFM_BRIGHT				14
#define _GFM_WRAP					15
#define _GFM_TITLE				16
#define _GFM_FOOTER				17
#define _GFM_SPACING				18
#define _GFM_DEPTH	 			19
#define _GFM_DEPTHCHART			19
#define _GFM_DEPTHCHARGE		19
#define _GFM_RUN_COUNT			19

// Concessions for our British users
#define _GFM_MENUCOLOUR			1
#define _GFM_FRAMECOLOUR		2
#define _GFM_BACKCOLOUR			3

// Other settings used by GrumpMenu
#define _GFM_SYSTEM				20
#define _GFM_SIZABLE				21
#define _GFM_SIZEABLE			21
#define _GFM_SECURITY			22
#define _GFM_CFGFILE				23
#define _GFM_CURCOL				24
#define _GFM_LEVEL				25
#define _GFM_ROWOFFSET			26
#define _GFM_CFGHIT				27
#define _GFM_MENUBOX				28
#define _GFM_MENUBYTE			29
#define _GFM_INSTALL				30
#define _GFM_ACTIVE				31
#define _GFM_DOSLINE				32
#define _GFM_BYTE					33
#define _GFM_PROMPT_ARRAY		34
#define _GFM_CURRENT_COORDS	35
#define _GFM_STABLE				36
#define _GFM_RESIZE				37
#define _GFM_DIRECTION			38
#define _GFM_SET_COUNT			38

// This is used by GFMSet()
#define _GFM_PROMPT				1
#define _GFM_VALUE				2
#define _GFM_PROMPT_WIDTH		21

#define _GFM_HOTPROMPT			1
#define _GFM_HOTKEY				2
#define _GFM_HOTLEVEL			3

#define _GFM_LEFT					-1
#define _GFM_RIGHT		 		1

#xtrans MenuSizeNumber( <a> [,<v>])	=> (<a>)\[1] [:=<v>]
#xtrans MenuSizeTop( <a> [,<v>])		=> (<a>)\[2] [:=<v>]
#xtrans MenuSizeLeft( <a> [,<v>])	=> (<a>)\[3] [:=<v>]
#xtrans MenuSizeBottom( <a> [,<v>])	=> (<a>)\[4] [:=<v>]
#xtrans MenuSizeRight( <a> [,<v>])	=> (<a>)\[5] [:=<v>]

#ifndef _JFK_CH
// Duplicates of definitions in jfk.ch
#define TRUE		.T.
#define FALSE		.F.

#command DEFAULT <p1> TO <v1> [,<pN> TO <vN>] =>;
	if ( <p1> == NIL ); <p1>:= <v1>;	end;
	[;if ( <pN> == NIL ); <pN>:= <vN>;	end]

#command REPEAT	=> while .t.
#command UNTIL <exp> => if <exp>; exit; end; end
#command IF <exp> THEN <*x*> => if <exp>; <x>; end
#command ELSEIF <exp> THEN <*x*> => elseif <exp>; <x>

#trans MakeBlock( <e> )	=>	&( "{||" + <e> + "}" )
#trans Full( <v> )	=>	( !Empty( <v> ) )
#endif

// EOF
