/*
    Program: YES_NO2()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper yesno2 /n/w/a

    Syntax:     Yes_No(<question>, [<top row>, <yes_msg>, <no_msg>,
                <init_val>, <box_color>, <opt_color>])

    Parameters: <question> -- message to display (character string)
                <top row> -- top row of box (numeric, default 20)
                <yes_msg> -- yes prompt (character, default " YES ")
                <no_msg>  -- no prompt (character, default " NO ")
                <init_val>-- which value to highlight first
                             (.T. = Yes, .F. - No, default Yes)
                <box_color>  color to draw box and question (character,
                             string, default +W/RB)
                <opt_color>  color to draw prompts (character string,
                             default W/RB for unselected, I for selected)

    Returns:  True if user selected YES, False if user selected NO or Escaped
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

function Yes_No2(msgs, ntop, cyes_msg, cno_msg, init_val, ;
                 box_color, opt_color)
local boxleft, optslen, oldscrn, optionstr, key, mlen, x := 0
GFSaveEnv( , 0)      // shut off cursor

// if message passed was a character string, convert to array
if valtype(msgs) = "C"
   msgs = { msgs }
endif
mlen = len(msgs)

// establish variables if not passed as parameters
default ntop to maxrow() / 2 - mlen - 1
default cyes_msg to " YES "
default cno_msg to " NO "
default init_val to YES

// determine width of longest message in array
aeval(msgs, { | a | x := max(len(a), x) } )

// determine width of box, and accordingly, left column of box
optslen := len(cyes_msg) + len(cno_msg) + 3   // allow 3 spaces btwn yes & no
boxleft := int((maxcol() - 5 - max(x, optslen)) / 2)

// save environment and get on with it
ColorSet(if(box_color == NIL, C_YESNO, box_color))
oldscrn = shadowbox(ntop, boxleft, ntop + 3 + mlen, maxcol() - boxleft, 2)
for x = 1 to mlen
   SCRNCENTER(ntop + x, msgs[x])
next
optionstr := upper(left(ltrim(cyes_msg), 1)) + upper(left(ltrim(cno_msg), 1))

// main keypress loop
do while .t.
   // draw yes and no options in appropriate colors... if the
   // options color parameter was not passed, go with the standard
   // YESNO color for unselected, and GETS color for selected
   ColorSet(if(init_val, C_GETS, IF(opt_color == NIL, C_YESNO, opt_color)))
   setpos(ntop + mlen + 2, int(( maxcol() + 1 - optslen) / 2))
   dispout(cyes_msg)
   ColorSet(if(! init_val, C_GETS, IF(opt_color == NIL, C_YESNO, opt_color)))
   setpos(ntop + mlen + 2, col() + 3)
   dispout(cno_msg)

   key := ginkey(0)
   do case
      case key == K_ESC
         init_val := NO
         exit
      case key == K_ENTER
         exit
      case key == K_LEFT .or. key == K_RIGHT
         init_val := ! init_val
      case upper(chr(key)) $ optionstr
         init_val := (at(upper(chr(key)), optionstr) = 1)
         exit
   endcase
enddo

// restore environment and get out of here
GFRestEnv()
ByeByeBox(oldscrn)
return (init_val)

* end function Yes_No2()
*--------------------------------------------------------------------*

* eof yesno2.prg
