/*
    Program: YES_NO()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.01 Version
    Compile instructions: clipper yesno /n /a

    Display a Yes/No question and wait for user to respond
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives


function yes_no(cmsg, cmsg2, cboxcolor, ctextcolor)
local nwidth, oldscrn, loneline := .F., ntop := 19
GFSaveEnv(, 0)                  // shut off cursor
default cmsg2 to []

// determine how many lines will be displayed, and top row of box
if empty(cmsg2)
   loneline := .T.
   ntop++
   cmsg += '? Y/N '
   nwidth := int(max(maxcol() - 5 - len(cmsg), 0)) / 2
else
   cmsg2 += '? Y/N '
   nwidth := int(maxcol() - 5 - max(len(cmsg), len(cmsg2))) / 2
endif

// establish box color
do case
   case cboxcolor == NIL           // not passed as parameter -- use default
      ColorSet(C_YESNO)
   case len(cboxcolor) == 0        // passed null string -- use default
      ColorSet(C_YESNO)
   otherwise                       // override
      ColorSet(cboxcolor)
endcase

oldscrn := shadowbox(ntop, nwidth, 22, maxcol() - nwidth, 3)
SCRNCENTER(if(loneline, 21, 20), cmsg, ctextcolor)
if ! loneline
   SCRNCENTER(21, cmsg2, ctextcolor)
endif
do while ! upper(chr(ginkey(0))) $ 'YN'
enddo
byebyebox(oldscrn)
GFRestEnv()
return (upper(chr(lastkey())) == "Y")

* end function Yes_No()
*--------------------------------------------------------------------*

* eof yesno.prg
