/*
   Function: WORLDUPPER()
   Author:   Greg Lief
   Copyright (c) 1990 Greg Lief
   Dialect:  Clipper 5.0
   Purpose:  converts a character string to upper-case, and handles
             seven special extended ASCII characters
   Syntax:   WorldUpper(<string to convert>)
   Returns:  Character string converted to uppercase
   Modified: 04/15/91 -- added support for '' and ''
             special characters (thanks to Morten Ross)
*/
function worldupper(mstring)
local x, mchr, ele, ret_val := [], codes_ := { { 129, 154 } , { 130, 144 } , ;
      { 132, 142 }, { 134, 143 }, { 135, 128 }, { 145, 146 }, { 148, 153 },  ;
      { 164, 165 }, { 237, 233 } }
for x = 1 to len(mstring)
   mchr := asc(substr(mstring, x, 1))
   do case
      *** lower-case letter key
      case mchr > 96 .and. mchr < 123
         ret_val += chr(mchr - 32)

      case (ele := ascan(codes_, { | x | x[1] == mchr} ) ) > 0
         ret_val += chr(codes_[ele, 2])

      otherwise
         ret_val += chr(mchr)

   endcase
next
return ret_val

* eof: wupper.prg
