/*
     Function: WaitOn()
     System: GRUMPFISH LIBRARY
     Author: Greg Lief
     Copyright (c) 1988-90, Greg Lief
     Clipper 5.01 Version
     Compile instructions: clipper waiton /n/w/a

     Display a wait message on the screen -- ideal for any tedious
     process.  If first parameter passed to this function is of logical
     type, it will assume that your tedious process has ended and will
     thus restore the affected portion of the screen.

     Calls: ShadowBox()    (function contained in SHADOWBO.PRG)
            ByeByeBox()    (function contained in BYEBYE.PRG)
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function waiton(msgs, lsound, ccolor, ntop, nleft)
local x := 0, mlen
static waitsound, waitstack_ := {}

// if the first parameter passed was of logical type, that means
// that the tedious process is over and we are to restore the screen
if valtype(msgs) == "L"
   // make sure that WAITON() was called first -- if it was not,
   // the waitstack_ array will be empty
   if ! empty(waitstack_)
      if waitsound .or. (lsound != NIL .and. lsound)
         tone(MUSIC_WAITON[2], 1)
         tone(MUSIC_WAITON[1], 1)
      endif
      ByeByeBox(atail(waitstack_))
      truncate(waitstack_)
   endif
else
   // establish message -- use default if not passed
   default msgs to { 'Now printing... please wait' }
   default lsound to .t.

   // if message passed was a character string, convert to array
   if valtype(msgs) == "C"
      msgs := { msgs }
   endif
   mlen := len(msgs)

   gfsaveenv( , 0)             // shut off cursor
   // use color default if not passed
   ColorSet(IF(ccolor == NIL, C_WAITMESSAGE, ccolor))
   // use default coordinates (centered on screen) if not passed
   default ntop to maxrow() / 2 - len( msgs )

   // determine width of longest message in array
   aeval(msgs, { | a | x := max(len(a), x) } )

   default nleft to int(maxcol() - 3 - x) / 2
   aadd(waitstack_, shadowbox(ntop, nleft, ntop + mlen + 1, nleft + 3 + x, 1))
   waitsound := lsound
   if ccolor == NIL
      ColorSet( C_WAITMESSAGEBLINK )
   endif
   setpos(ntop, 0)
   aeval(msgs, { | line | setpos(row() + 1, nleft + 2), dispout(line) } )
   if waitsound
      tone(MUSIC_WAITON[1], 1)
      tone(MUSIC_WAITON[2], 1)
   endif
   gfrestenv()
endif
return NIL

* end function WaitOn()
*--------------------------------------------------------------------*

* eof waiton.prg
