/*
    Program: VSCRNSCRL()
    System:  GRUMPFISH LIBRARY
    Author:  Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper vscroll /n/w/a

    Displays screen in vertical row-by-row increments

    NOTE: screen must be pre-saved to the <screen file> using
    HBlindSave())

    Syntax: VSCRNSCRL(<screen file> [, <nDirection> ])

    Optional parameter <nDirection> determines whether the display
    will be pull-down or pop-up.  Pass 1 for pop-up, -1 for pull-down.
    (Default is pull-down.)  Thanks to Evan Davies for the suggestion!

    WILL HANDLE 25/43/50 ROW DISPLAYS
*/

// begin preprocessor directives

#include "fileio.ch"
#include "grump.ch"

// end preprocessor directives

function VScrnScrl(cfile, ndirection)
local maxrow := maxrow() + 1, maxcol := maxcol() + 1
local handle, screen_[maxrow], buffer, xx, yy, bufflen := maxcol * 2
local loopers_
default ndirection to -1                // default is pull-down
if file(cfile)
   handle := fopen(cfile, FO_READ)
   if handle != F_ERROR
      // verify that this file was saved in the same mode that we are in
      // because if it wasn't, all hell will break loose further down
      if fseek(handle, 0, FS_END) == maxrow * maxcol * 2
         fseek(handle, 0, FS_SET)       // reset to start of file
         for xx = 1 to maxrow
            buffer := space(bufflen)
            fread(handle, @buffer, bufflen)
            screen_[xx] := buffer
         next
         fclose(handle)
         /*
             load LOOPERS_ array based on direction -- structure is:
                  LOOPERS_[1] := starting row for FOR..NEXT loop
                  LOOPERS_[2] := ending row for FOR..NEXT loop
                  LOOPERS_[3] := row to be displayed within loop
         */
         if ndirection == 1                     // pop-up
            loopers_ := { 1, maxrow, maxrow }
         else                                   // pull-down
            loopers_ := { maxrow, 1, 0 }
         endif
         for xx = loopers_[1] to loopers_[2] step ndirection
            scroll(0, 0, maxrow, maxcol, ndirection)
            restscreen(loopers_[3], 0, loopers_[3], maxcol, screen_[xx])
         next
      endif
   endif
endif
return NIL

* end function VScrnScrl()
*--------------------------------------------------------------------*

* eof vscroll.prg
