/*
    Program: UP_N_DOWN()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper upndown /n/w/a
    Special thanks to Greg Smith and Dennis Levin for their input!

    Flexible upper and lower case data entry -- for example, if
    you have one field for the entire name (first and last),
    this will automatically make each name proper (first letter
    upper, rest lower).
*/

// begin preprocessor directives

#include "inkey.ch"

// end preprocessor directives

function up_n_down(cstring)
local mrow := row(), mcol := col(), key := 0, mkey, ;
      origvar := cstring, ;        // save original value in case of ESC
      ret_val := replicate('X', len(cstring)), ;  // the picture clause
      nlength := len(cstring), ;   // set maximum length for data entry
      nextupper := .t.             // first character must be upper-case
GFSaveEnv()
setcolor(substr(setcolor(), at(',', setcolor()) + 1))  // sneaky sneaky
@ mrow, mcol say cstring                               // initial display
cstring := []

/*
  begin main loop

  we simulate an actual read by allowing the following active keys:
  enter,  esc,  ctrl-w,  uparrow, downarrow, pgup, and pgdn

  if you want to limit escape from this routine, it is a simple
  matter to remove the desired key values from the next statement

  note also that we fall out of the loop when nlength reaches 0.  this
  effectively simulates set confirm off.
*/

do while key != K_ENTER .and. key != K_ESC .and. key != K_CTRL_W .and. ;
         key != K_UP .and. key != K_DOWN .and. key != K_PGUP .and.     ;
         key != K_PGDN .and. nlength > 0
   @ mrow, mcol say cstring picture ret_val
   key := ginkey(0)
   do case

      // user pressed an alphanumeric or punctuation key
      case (key > 32 .and. key < 91) .or. (key > 96 .and. key < 123)
         // if this is an alpha, we must do additional testing
         mkey := chr(key)
         if key > 64
            if nextupper
               // if the next character should be upper but they entered
               // an upper, switch case to lower: huh?  this is so that
               // someone could enter, for example, "dBASE"
               if key < 91
                  mkey := chr(key + 32)
               // force upper-case if called for
               else
                  mkey := chr(key - 32)
               endif
            endif
         endif
         cstring += mkey
         nextupper := .f.
         nlength--             // decrement the length counter

      case key == 32
         nextupper := .t.      // next character will be uppercase
         cstring += [ ]
         nlength--             // decrement the length counter

      case key == K_BS .and. len(cstring) > 0
         cstring := substr(cstring, 1, len(cstring) - 1)
         // clear last character the easy way
         scroll(mrow, col()-1, mrow, col()-1, 0)
         // if we are at a space or back at the beginning of the
         // string, next character must be uppercase
         nextupper := (substr(cstring, len(cstring)) = chr(32) .or. ;
                       len(cstring) = 0)
         nlength++      // increment the length counter

   endcase
enddo

do case
   // reset CSTRING to its original value
   case key == K_ESC
      cstring := origvar
      keyboard chr(K_ENTER)
   // entered max number of characters - stuff enter to continue
   case nlength == 0
      keyboard chr(K_ENTER)
   // any other key -- stuff it into buffer to be acted upon properly
   otherwise
      keyboard chr(key)
endcase

// restore environment to previous state
GFRestEnv()
// pad the string back to its original length
cstring := padr(cstring, len(ret_val))
return ret_val

* end function Up_N_Down()
*--------------------------------------------------------------------*

* eof upndown.prg
