/*
    Function: TTY2()
    System:   GRUMPFISH LIBRARY
    Author:   Greg Lief, with help from Dennis Levin
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper tty /n/w/a

    Displays message on screen "teletype" style until keypress
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives


function tty2(nrow, cmsg, ndelay, ccolor)
local nlen, leftcol, xcol, nstart, mstring, yy, maxcol := maxcol()

if nrow <= maxrow()
   GFSaveEnv( { nrow, 0, nrow, maxcol() } )

   // use default message if a null string was passed
   default cmsg to 'Press any key to continue'
   // truncate the message if longer than 70 characters
   cmsg := substr(cmsg, 1, 70)

   // set ndelay factor to 0 if not passed and make sure it is a numeric!
   default ndelay to 0

   setcolor(ccolor)
   nlen := len(cmsg) + 10            // determine how many dots to use
   leftcol := int((maxcol + 1 - nlen) / 2)
   @ nrow, leftcol ssay replicate(chr(46), nlen)
   xcol := leftcol + nlen - 6        // start five columns from the right
   nstart := 1                       // substring ptr for when we hit the left
   do while inkey() = 0
      mstring := substr(cmsg, nstart, nlen + leftcol - xcol - 5) + ;
                 if(nstart > 1, replicate(chr(46), nstart - 1), '')
      @ nrow, xcol ssay mstring
      if ndelay == 0            && use sound
         tone(MUSIC_TTY, 1)
      else
         for yy = 1 to ndelay
         next
      endif
      if xcol == leftcol + 5                    // we're at the left side
         if ++nstart > nlen - 10                // time to go back to the right
            @ nrow, xcol ssay chr(46)           // clear remainder of message
            xcol := leftcol + nlen - 5          // reset column pointer
            nstart := 1                         // reset substring pointer
         endif
      else
         xcol--
      endif
   enddo
   GFRestEnv()
endif
return NIL

* end function TTY2()
*--------------------------------------------------------------------*

* eof tty2.prg
