/*
    Program: TTY()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90 Grumpfish, Inc. - All Rights Reserved
    Clipper 5.x Version
    Compile instructions: clipper tty /n/w/a

    Displays message on screen "teletype" style until keypress
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function tty(nrow, msg, ndelay, nstopcol)
local xcol := 0, yy, maxcol := maxcol(), ;
      oldscrn := savescreen(nrow, 0, nrow, maxcol())
if nrow <= maxrow()
   GFSaveEnv()
   // set sound and stop column if parameters were not passed
   ndelay := if(ndelay == NIL, 0, ndelay)
   nstopcol := if(nstopcol == NIL, -1, nstopcol)
   do while inkey() = 0 .and. nstopcol != xcol
      @ nrow, xcol ssay chr(32) + ;
              if(xcol < maxcol, substr(msg, 1, maxcol-xcol), '')
      if maxcol - xcol < len(msg)
         @ nrow, 0 ssay substr(msg, maxcol + 1 - xcol, len(msg) - maxcol + xcol)
      endif
      if ndelay == 0
         tone(MUSIC_TTY, 1)
      else
         for yy = 1 to ndelay
         next
      endif
      if xcol == maxcol
         xcol := 0
      else
         xcol++
      endif
   enddo
   // reset previous environment
   GFRestEnv()
   // do not restore screen if stop column was passed
   if nstopcol == NIL
      restscreen(nrow, 0, nrow, maxcol, oldscrn)
   endif
endif
return NIL

* end function TTY()
*--------------------------------------------------------------------*

* eof tty.prg
