/*
    Program: TIMESTAMP()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.01 version
    Compile instructions: clipper timesta /n/w/a

    Calls:   MEMEDIT()  (function contained in MEMEDIT.PRG)
             ERR_MSG()  (function contained in ERRMSG.PRG)

    To implant a date/time stamp into a memo field. Handy
    for customer contact records and so forth
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function timestamp(cfield, cvalue, edit_it)
local oldinsert, mrow := row(), mcol := col(), cstring
default cvalue to []
if type(cfield) = 'M'   // VALTYPE() did not seem to work in this situation
   // if third parameter was passed, put them into memoedit()
   cstring := dtoc(date()) + [ ] + time() + [ ] + ;
             if(! empty(cvalue), cvalue, []) + CRLF
   if edit_it != NIL
      oldinsert := readinsert(.t.)
      keyboard cstring + CRLF + chr(5) + chr(5) + replicate(chr(4), 18)
      memedit(cfield)
      readinsert(oldinsert)
   elseif rlock()
      fieldput(fieldpos(cfield), cstring + fieldget(fieldpos(cfield)))
      // note complete absence of macro operators!
   else
      err_msg( { "Could not write timestamp to " + cfield })
   endif
endif
setpos(mrow, mcol)    // return cursor position
return NIL

* end function TimeStamp()
*--------------------------------------------------------------------*

* eof timesta.prg
