/*
     Function: Sv_FadeIn()
     System: GRUMPFISH LIBRARY
     Author: Greg Lief
     Copyright (c) 1988-90, Greg Lief
     Clipper 5.x Version
     Compile instructions: clipper svfadei /n/w/a

     Syntax: Sv_FadeIn(<filename>)

     Parameter: <filename> is a character string representing the name
                of file in which to save the hacked up screen.

     Returns: Nothing worth writing home about
*/
function Sv_FadeIn(cfile)
local maxrow := maxrow()+1, maxcol := maxcol()+1, x, mrow, mcol
local elements := maxrow * maxcol, oldprinter := set(_SET_PRINTFILE, cfile)
local oldconsole := set(_SET_CONSOLE, .F.), a[elements], ncount := 0, cbuff
set print on
afill(a, 0)
do while ncount < elements
   x := gfrand(elements)
   if a[x+1] = 0
      a[x+1] := 1
      mrow := INT(x / maxcol)
      mcol := INT(x % maxcol)
      cbuff := savescreen(mrow, mcol, mrow, mcol)
      ?? chr(mrow) + chr(mcol) + cbuff
      ncount++
   ENDIF
ENDDO
set(_SET_PRINTFILE, oldprinter)
set(_SET_CONSOLE, oldconsole)
set print off
return NIL

* end function Sv_FadeIn()
*--------------------------------------------------------------------*

* eof svfadei.prg
