/*
    Program: SPREAD()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-93, Greg Lief
    Clipper 5.x version
    Compile instructions: clipper spread /n /w
    Displays a character string from the center out
*/

#include "grump.ch"

function Spread(cMessage, nRow, nDelay, nMidPoint)
local nLength := len(cMessage)
local xx
local yy
local zz := int(nLength / 2)
default nDelay to 10
default nMidPoint to (maxcol() + 1) / 2
for xx := 1 to int(nLength / 2)
   @ nRow, nMidPoint - xx ssay substr(cMessage, 1, xx) + ;
                               substr(cMessage, nLength + 1 - xx, xx)
   for yy := 1 to nDelay
   next
next
// if message was of odd length, redraw entire thing now
if nLength % 2 == 1
   @ nRow, nMidPoint - xx say cMessage
endif
return NIL

* end function Spread()
*--------------------------------------------------------------------*

* eof spread.prg
