/*
    Program: SHRBOX()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper shrbox /n/w/a
    Draws the incredible shrinking box
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function shrbox(ntop, nleft, nbottom, nright, ndelay, ccolor)
local medver, medhor, dom, ii, jj, oldcolor := setcolor(ccolor)
default ndelay to 20
if iscolor()    // one needs a color monitor to get the full effect
   medver := int(((nbottom - ntop) + 1) /2)   // determine vertical median
   medhor := int(((nright - nleft) + 1) /2)   // determine horizontal median
   dom := max(medver, medhor)
   for ii = dom to 1 step -1
      for jj = 1 to ndelay   // slow down implosion
      next

      // blank out previous box outline
      @ ntop, nleft, nbottom, nright box space(9)
      if ii < medver
         ntop++
         nbottom--
      endif
      if ii < medhor
         nleft++
         nright--
      endif
   next
endif
// blank out remaining box area
scroll(ntop, nleft, nbottom, nright, 0)
setcolor(oldcolor)
return NIL

* end function ShrBox()
*--------------------------------------------------------------------*

* eof shrbox.prg
