/*
   Program: SHADOWBOX()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.01 version
   Compile instructions: clipper shadowb /n/w/a
   Draws shadowed box
   Calls: BOX_TITLE()      (Function in BOXTITLE.PRG)
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function Shadowbox(ntop, nleft, nbottom, nright, ntype, ctitle, ;
                   lcrossbar, ccolor, cfooter)
local boxstring, ret_val
gfsaveenv()
// establish defaults
default ntype to 1
default ctitle to []
lcrossbar := if(valtype(lcrossbar) == "L", lcrossbar, ;
                lcrossbar <> NIL)

// limit border number to avoid array crash
boxstring := BOXFRAMES[if(ntype > 6 .or. ntype < 1, 1, ntype)]

// construct array containing coordinates & contents of screen
// area underneath this box - this can be used with byebyebox()
ret_val := { ntop, nleft, nbottom + 1, nright + 2, ;
             savescreen(ntop, nleft, nbottom + 1, nright + 2) }

// draw shadow if coordinates are valid
if nbottom < maxrow() .and. nright < maxcol() - 1
   gfattr(ntop + 1, nright + 1, nbottom + 1, nright + 2, 8)
   gfattr(min(nbottom + 1, maxrow() - 1), nleft + 2, nbottom + 1, nright + 2, 8)
endif

// draw box outline
@ ntop, nleft, nbottom, nright box boxstring color ccolor

// draw title if requested
if len(ctitle) > 0
   box_title(ntop, nleft, nright, ctitle, boxstring, lcrossbar, ccolor)
endif

// draw footer if requested
if cfooter <> NIL
   box_title(nbottom, nleft, nright, cfooter, boxstring, .f., ccolor)
endif
gfrestenv()
return (ret_val)

* end function ShadowBox()
*--------------------------------------------------------------------*

* eof shadowb.prg
