/*
   Program: SETFILT.PRG
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.01 Version
   Compile instructions: clipper setfilt /n/w/a

   User-friendly interactive query builder
*/

#include "grump.ch"
#include "inkey.ch"
#include "dbstruct.ch"

// the following three items are declared here because they must
// be visible within several functions herein

static mfilter            // the filter condition being built
static mefilter           // english translation of same
static fieldinfo          // array of info for the current field

// manifest constants to make things more readable
#define FieldName  fieldinfo[DBS_NAME]
#define FieldType  fieldinfo[DBS_TYPE]
#define FieldLen   fieldinfo[DBS_LEN]

// manifest constants for return values from AddFilt() to NewFilt()
#define DISCARDED  1
#define DONE      12
#xtranslate ShowFilt() => memoedit(mefilter, 04, 01, 17, 37, .f., .f.)

external soundex

function setfilt(aDescrip)
local malias
local run_it_now
local oldscore := set(_SET_SCOREBOARD, .f.)
local maincolor := ColorSet(C_APICK_BOXOUTLINE, .T.)
local browse
local column
local mcount
local buffer
local oldcolor
local key
local oldfkeys_
local mainloop := .t.

if empty( malias := upper(alias()) )
   err_msg( { "No database open" } )
else
   // must disable F7, F8, F9, F10 because they are used in my main
   // keypress loop below
   oldfkeys_ := { setkey(K_F7, NIL), setkey(K_F8, NIL), ;
                  setkey(K_F9, NIL), setkey(K_F10, NIL) }
   GFSaveEnv(.t., 0)       // shut off cursor
   scroll()
   if ! file('queries.dbf')
      waiton('initializing query file... please wait')
      dbcreate('queries.dbf', { { "DESCRIP",   "C", 50, 0 } , ;
                              { "MFILTER",   "M", 10, 0 } , ;
                              { "MEFILTER",  "M", 10, 0 } , ;
                              { "QUERY_FILE","C",  8, 0 } } )
      waitoff()
   endif
   use queries new

   // give user choice of existing queries first
   // create new browse object
   browse := TBrowseDB(5, 15, 19, 64)
   browse:headSep := ""
   browse:colorSpec := maincolor + ', I, W/B, N/W'
   column := TBColumnNew( "Query Description", { | | queries->descrip } )
   browse:addColumn(column)

   @ maxrow(),03 ssay 'move'
   @ maxrow(),14 ssay 'count'
   @ maxrow(),25 ssay 'delete'
   @ maxrow(),37 ssay 'view'
   @ maxrow(),48 ssay 'new query'
   @ maxrow(),63 ssay 'select'
   @ maxrow(),76 ssay 'exit'
   setcolor('I')
   @ maxrow(),00 ssay chr(24)+chr(25)
   @ maxrow(),11 ssay 'F7'
   @ maxrow(),22 ssay 'F8'
   @ maxrow(),34 ssay 'F9'
   @ maxrow(),44 ssay 'F10'
   @ maxrow(),60 ssay chr(17) + ""
   @ maxrow(),72 ssay 'Esc'
   ColorSet(C_APICK_BOXOUTLINE)
   set filter to trim(queries->query_file) == malias
   go top
   shadowbox(04, 14, 20, 65, 3)
   do while mainloop
      do while (key := inkey()) = 0 .and. ! browse:stabilize()
      enddo
      if browse:stable
         key := ginkey(0, "KEY")
      endif
      do case
         case key == K_UP
            browse:up()
         case key == K_LEFT
            browse:left()
         case key == K_RIGHT
            browse:right()
         case key == K_DOWN
            browse:down()
         case key == K_CTRL_PGUP
            browse:goTop()
         case key == K_CTRL_PGDN
            browse:goBottom()
         case key == K_PGUP .or. key == K_HOME
            browse:pageUp()
         case key == K_PGDN .or. key == K_END
            browse:pageDown()
         case key == K_ESC
            mainloop := .f.
         case key == K_ENTER
            if eof()
               err_msg( { "No query to select!" } )
            else
               if ! empty(queries->mfilter)
                  select(select(malias))
                  waiton('Searching records.. please wait')
                  dbsetfilter(&("{ || " + queries->mfilter + "}"), ;
                              queries->mfilter )
                  go top
                  if eof()
                     err_msg( { 'No records meet those criteria' } )
                     set filter to
                     select queries
                     waitoff()
                  else
                     waitoff()
                     mainloop := .f.
                  endif
               else
                  select(select(malias))
                  go top
                  mainloop := .f.
               endif
            endif

         case key == K_F7     // count records for this query
            if eof()
               err_msg( { 'No query to count' } )
            else
               select(select(malias))
               waiton('Now counting records.. please wait')
               go top
               // if the filter condition is empty, then the "filter" is
               // a moot point -- show 'em total # of records
               if empty(queries->mfilter)
                  mcount := lastrec()
               else
                  mfilter := &("{ | | " + queries->mfilter + "}" )
                  count for eval(mfilter) to mcount
               endif
               oldcolor := ColorSet(C_WAITMESSAGE)
               @ 12, 23 ssay padr( str(mcount, 8) + ' record' + ;
                                  if(mcount > 1, 's', '') + ;
                                  ' for this criteria', 34)
               ginkey(0)
               waitoff()
               setcolor(oldcolor)
               select queries
            endif

         case key == K_F8                     // delete query
            if eof()
               err_msg( { 'No query to delete' } )
            else
               if yes_no('Are you sure you want to delete this query')
                  if rlock()
                     delete
                     use queries exclusive
                     if ! neterr()
                        waiton('deleting query.... please wait')
                        pack
                        copy structure to tempqry
                        use tempqry exclusive
                        append from queries
                        ferase('queries.dbf')
                        ferase('queries.dbt')
                        use
                        frename('tempqry.dbf', 'queries.dbf')
                        frename('tempqry.dbt', 'queries.dbt')
                        use queries
                        set filter to trim(queries->query_file) == malias
                        go top
                        waitoff()
                        browse:refreshAll()
                     else
                        err_msg( { NETERR_MSG } )
                     endif
                  else
                     err_msg( { NETERR_MSG } )
                  endif
                  unlock
               endif
            endif

         case key == K_F9                     // view criteria
            if eof()
               err_msg( { 'No query to view' } )
            else
               oldcolor := ColorSet(C_ERRORMESSAGE)
               buffer := shadowbox(07, 25, 17, 54, 4, 'Query Criteria')
               @ 17,30 ssay ' press Esc to exit '
               memoedit(queries->mefilter, 8, 26, 16, 53, .f.)
               setcolor(oldcolor)
               byebyebox(buffer)
            endif

         case key == K_F10                    // create new query
            buffer := savescreen(0, 0, 24, 79)
            select(select(malias))
            run_it_now := NewFilt(malias, aDescrip)
            restscreen(0, 0, 24, 79, buffer)
            go top
            if run_it_now
               select(select(malias))
               waiton('Searching records.. please wait')
               if ! empty(mfilter)
                  dbsetfilter(&("{ || " + mfilter + "}"), mfilter )
               endif
               go top
               if eof()
                  err_msg( { 'No records meet those criteria' } )
                  set filter to
                  select queries
               else
                  waitoff()
                  mainloop := .f.
               endif
            endif
            browse:refreshAll()

      endcase
   enddo

   GFRestEnv()
   select queries
   use
   if len(malias) > 0
      select(select(malias))
   endif

   // reset F7, F8, F9, F10 keys to their previous values
   for key := 1 to 4
      setkey(-(key + 5), oldfkeys_[key])
   next
endif
return nil

* end function SetFilt()
*--------------------------------------------------------------------*


/*
   Function: NewFilt()
*/
static function NewFilt(malias, aDescrip)
local botrow, returncode, run_it_now := .f., oldcolor := setcolor(), ;
      firstloop := .t., browse, column, key, mdescrip := space(50), ;
      marker := recno(), fields_ := dbstruct(), ele := 1, ;
      getlist := {}, mainloop := .t.
local openparen := 0       // number of open parentheses in filter criteria
local nMaxwidth := 0

// initialize selection array based on whether a layman's description
// array was passed as a parameter to SETFILT()
if aDescrip == NIL
   aDescrip := array( len(fields_) )
   aeval(fields_, { | f, ele | aDescrip[ele] := f[DBS_NAME] } )
endif
// must determine maximum width for sizing TBrowse window
nMaxwidth := 0
aeval(aDescrip, { | f | nMaxwidth := max(nMaxwidth, len(f) ) } )

// initialize filter condition and english translation
mfilter := []
mefilter := 'ALL RECORDS'

// use phantom record to get initial value for this field
go bott
skip

setcolor('w/n')
dispbegin()
scroll()
colorset(C_APICK_BOXOUTLINE)
@0,33 ssay " query builder "
exbox(3, 0, 18, 38, 2, 0, '', .f., 'selection criteria')
@ 04,01 ssay mefilter
botrow := min(fcount() + 2, 23)
SINGLEBOX(20, 00, 24, 25)
@ 21,05 ssay 'Move Highlight Bar'
@ 22,06 ssay 'To Select An Item'
@ 23,06 ssay 'To End Selection'
@ 21,02 ssay chr(24)+chr(25) color 'I'
@ 22,02 ssay chr(17)+"" color 'I'
@ 23,02 ssay 'Esc' color 'I'

browse := TBrowseNew( 2, 61 - (nMaxwidth / 2), botrow - 1, ;
                      61 + (nMaxwidth / 2) - (nMaxwidth % 2) )
browse:colorSpec := colorset(C_APICK_BOXOUTLINE, .t.) + ", I"
browse:skipBlock := { | SkipCnt | Gilligan(@ele, SkipCnt, len(fields_)) }
column := TBColumnNew( "", { | | aDescrip[ele] } )
column:width := nMaxwidth
browse:addColumn(column)
ShadowBox(1, browse:nLeft - 1, botrow, browse:nRight + 1, 4, 'Fields')
dispend()
do while mainloop
   do while (key := inkey()) == 0 .and. ! browse:stabilize()
   enddo
   if browse:stable
      ShowFilt()
      key := ginkey(0, "KEY")
   endif
   do case
      case key == K_UP
         browse:up()
      case key == K_DOWN
         browse:down()
      case key == K_ENTER .and. fields_[ele][DBS_TYPE] != "M"
         // dump this particular array element to a mini-array!
         // note that fieldinfo is declared as an external static
         // at the top of this program because we need to have it
         // visible in the hot-key function VIEW_VALS
         fieldinfo := fields_[ele]
         // note that OPENPAREN may need to be altered in AddFilt()
         if (returncode := AddFilt(fieldinfo, aDescrip[ele], @openparen)) == DONE
            mainloop := .f.
         endif
         if firstloop .and. returncode > DISCARDED
            firstloop := .f.
         endif
      case key == K_ESC
         mainloop := .f.
   endcase
enddo
go marker
colorset(C_APICK_BOXOUTLINE)
ShowFilt()
select queries
ColorSet(C_MESSAGE)
shadowbox(09, 07, 15, 72, 2)
@ 10,09 ssay 'You may now enter a description of up to 50 characters for'
@ 11,09 ssay 'this query.  If you wish to run this query immediately without'
@ 12,09 ssay 'saving it, leave the description empty and press Enter.  If '
@ 13,09 ssay 'you want to exit without saving this query, press Esc.'
@ 14,15 get mdescrip
setcursor(1)
read
setcursor(0)
if lastkey() != K_ESC            // if user did not press esc
   if len(trim(mdescrip)) == 0   // left it blank -- do not save it
      run_it_now := .t.          // to run query immediately - see querybrow()
   else
      // force this record to be added with the following 'endless loop'
      do while .t.
         append blank
         if ! neterr()
            queries->descrip    := mdescrip
            queries->query_file := malias
            queries->mfilter    := mfilter
            queries->mefilter   := mefilter
            exit
         endif
      enddo
   endif
endif
setcolor(oldcolor)
return run_it_now

* end static function NewFilt()
*--------------------------------------------------------------------*


/*
   Function: ADDFILT()
*/
static function AddFilt(fieldinfo, cPseudo, openparen)

// arrays to be used when selecting fields and operators
static op_string := { '=', '<', '>', '<=', '>=', '<>' }
static operators := { 'Equal to', 'Less than', 'Greater than', ;
       'Less than or equal to', 'Greater than or equal to', 'Not equal to', ;
       'Contains', 'Does not contain', 'Sounds like' }
static op_choices := { .t., .t., .t., .t., .t., .t., .t., .t., .t., .t. }
static booleans := { 'Discard', ' .AND. ', ' .OR. ', '( ... .AND.', ;
                     '( ... .OR.', ' .AND. (', ' .OR. (', ') .AND. ', ;
                     ') .OR. ', ') .AND. (', ') .OR. (', '<<done>>' }
static bl_choices := { .t., .t., .t., .t., .t., .t., .t., .t., .t., .t., .t. }
local buffer1
local mvalue
local mfield
local mefield
local wid
local boxbott
local op
local mop
local meop
local mboolean
local pic_len
local mpic
local mplain := ColorSet(C_APICK_BOXOUTLINE, .T.)  + ',I'
local oldaltv
local menhanced := '+' + mplain
local getlist := {}
gfsaveenv(.t.)
mvalue := fieldget(fieldpos(FieldName))
do case
   case FieldType == 'C'
      if len(mvalue) > 35
         mpic := "@S35"
         pic_len := 35
      else
         mpic := replicate("X", (pic_len := len(mvalue)) )
      endif

   case FieldType == 'D'
      pic_len := 8
      mpic := "@D"

   case FieldType == 'N'
      op := str(mvalue)
      if "." $ op
         mpic := replicate('9', at(".", op) - 1) + "."
         mpic += replicate('9', len(op) - len(mpic))
      else
         mpic := replicate('9', len(op))
      endif
      pic_len := len(mpic)

   case FieldType == 'L'
      pic_len := 1
      mpic := "Y"
endcase
mop := ' = '
meop := ' equal to '
if FieldType != 'L'       // get operator for non-logical fields
   colorset(C_YESNO)
   boxbott := if(FieldType == 'C', 13, 10)
   // note: trimming field pseudo-name to 24 characters
   buffer1 := shadowbox(2, 47, boxbott - 1, 72, 3, left(cPseudo, 24))
   op := 0
   // only permit access to soundex() and substr() choices if this
   // is a character variable -- logical enough, eh?
   op_choices[7] := op_choices[8] := op_choices[9] := (FieldType = 'C')
   do while op == 0
      op := achoice(3, 48, boxbott - 2, 71, operators, op_choices)
   enddo
   ByeByeBox(buffer1)
   meop := ' ' + trim(operators[op]) + ' '
   if op < 7
      mop := ' ' + op_string[op]
   endif
endif
wid := max(len(cPseudo) + len(meop) + pic_len, 30)
ColorSet(C_MESSAGE)
ShadowBox(05, 68 - wid, 08, 72, 4)
// establish ALT_V as hot-key for viewing values in database.
oldaltv := setkey(K_ALT_V, { ||  View_Vals() } )
@ 07, 42 ssay '(Alt-V for available values)'
@ 06, 70-wid ssay cPseudo + meop
@ 06, col() get mvalue picture mpic
setcursor(1)
read
setcursor(0)
setkey( K_ALT_V, oldaltv)     // restore ALT_V to its previous state
do case
   case FieldType == 'N'
      mfield := FieldName + mop + ltrim(str(mvalue))
      mefield := cPseudo + meop + ltrim(str(mvalue))
   case FieldType == 'L'
      mfield := if(mvalue, FieldName, '! ' + FieldName)
      mefield := if(mvalue, cPseudo, 'not ' + cPseudo)
   case FieldType == 'D'
      mfield := FieldName + mop + "ctod('" + dtoc(mvalue) + "')"
      mefield := cPseudo + meop + dtoc(mvalue)
   otherwise
      // criteria 7 and 8 ('contains' and 'sounds like') are special cases
      // and must be processed a bit differently than the first six
      do case
         case op == 7        // 'contains'
            mfield := '[' + trim(mvalue) + '] $ ' + FieldName
         case op == 8        // 'does not contain'
            mfield := '! [' + trim(mvalue) + '] $ ' + FieldName
         case op == 9        // 'sounds like'
            mfield := 'soundex(' + FieldName + ') = soundex([' + ;
                     trim(mvalue) + '])'
         otherwise
            mfield := FieldName + mop + "[" + trim(mvalue) + "]"
      endcase
      mefield := cPseudo + meop + "'" + trim(mvalue) + "'"
endcase
ColorSet(C_YESNO)
shadowbox(10, 54, 23, 67, 3)
mboolean := 0
// only allow selection of leading open parenthesis on first pass
bl_choices[4] := bl_choices[5] := empty(mfilter)
// only allow selection of something involving a closed parenthesis
// if there is at least one open parenthesis already...
bl_choices[8] := bl_choices[9] := bl_choices[10] := bl_choices[11] := (openparen > 0)
// force them to make a selection
do while mboolean == 0
   mboolean := achoice(11, 55, 22, 66, booleans, bl_choices)
enddo
if mboolean == len(booleans)
   // add the required number of closed parenthesis to balance it out
   mfilter += mfield + replicate(')', openparen)
   mefilter := strtran(mefilter,'ALL RECORDS', '') + mefield + ;
               replicate(')', openparen)
elseif mboolean > 1    // selection 1 means they want to discard this condition
   if mboolean > 3 .and. mboolean < 7
      openparen++
   elseif mboolean == 8 .or. mboolean == 9
      openparen--
   endif
   if empty(mfilter) .and. (mboolean == 4 .or. mboolean == 5)
      mfilter  := "( " + mfield + if(mboolean == 4, " .AND. ", " .OR. ")
      mefilter := "(" + mefield + if(mboolean == 4, " AND ", " OR ")
   else
      mfilter  += mfield + booleans[mboolean]
      mefilter := strtran(mefilter, 'ALL RECORDS', '') + mefield + ;
                  booleans[mboolean]
   endif
   setcolor(mplain)
   scroll(23, 02, 23, 24, 0)
endif
gfrestenv()
return mboolean

* end static function AddFilt()
*--------------------------------------------------------------------*


/*
    Function: VIEW_VALS
    Hot key (Alt-V) to pop up field values for quick reference
*/
static function view_vals
local browse, column, key, buffer, marker := recno(), ;
      oldblock := setkey( K_ALT_V, NIL )
gfsaveenv(, 0, colorset(C_APICK_BOXOUTLINE))
buffer := shadowbox(10, 70 - min(FieldLen, 70), 20, 71, 2)
browse := TBrowseDB(11, 71 - min(FieldLen, 70), 19, 70)
browse:headSep := ""
browse:colorSpec := colorset(C_APICK_BOXOUTLINE, .t.) + ',' + ;
                    colorset(C_APICK_INDICATOR, .t.)
column := TBColumnNew( "Value", FieldBlock(FieldName) )
browse:addColumn(column)
go top
do while key != K_ESC .and. key != K_ENTER
   do while (key := ginkey()) = 0 .and. ! browse:stabilize()
   enddo
   if browse:stable
      key := ginkey(0, "KEY")
   endif
   do case
      case key == K_UP
         browse:up()
      case key == K_DOWN
         browse:down()
      case key == K_CTRL_PGUP
         browse:goTop()
      case key == K_CTRL_PGDN
         browse:goBottom()
      case key == K_PGUP .or. key == K_HOME
         browse:pageUp()
      case key == K_PGDN .or. key == K_END
         browse:pageDown()
   endcase
enddo
if key != K_ESC
   getactive():varPut( fieldget(fieldpos(FieldName)) )
endif
go marker
byebyebox(buffer)
gfrestenv()
setkey(K_ALT_V, oldblock)   // reset Alt-V for next time
return NIL

* end static function View_Vals()
*--------------------------------------------------------------------*

* eof setfilt.prg
