/*
   SETS.PRG
   Functions to save and restore all SET variables
   Clipper 5.x version
   Compile instructions: clipper sets /n/w/a
   Copyright (c) 1990 Greg Lief - All Rights Reserved
*/

// begin global declarations

#include "grump.ch"

static setstack_ := {}       // will serve as SET stack

// end global declarations

/*
    Function: GFSaveSets()
    Purpose:  Save all SET variables onto the SET stack
*/
function GFSaveSets
local xx, settings_ := {}
for xx := 1 to _SET_COUNT            /* see STD.CH for this */
   aadd(settings_, set(xx))
next
aadd(setstack_, settings_)
return len(setstack_)

* end of function GFSaveSets()
*--------------------------------------------------------------------*


/*
    Function: GFRestSets()
    Purpose:  Restore all SET variables from the SET stack
*/
function GFRestSets(ele)
local xx, settings_
/* use LIFO (last item in array) if no parameter was passed */
default ele to len(setstack_)
/* preclude empty array! */
if len(setstack_) > 0 .and. ele <= len(setstack_)
   settings_ := setstack_[ele]
   for xx := 1 to _SET_COUNT            /* see STD.CH for this */
      set(xx, settings_[xx])
   next
   /* truncate length of array only if using LIFO, i.e., no param passed */
   if ele == len(setstack_) .and. pcount() = 0
      truncate(setstack_)
   endif
endif
return nil

* end of function GFRestSets()
*--------------------------------------------------------------------*

* eof sets.prg
