/*
   Program: GETS.PRG
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper gets /n/w/a

   Functions: GFSaveGets(), GFRestGets()

   Save or restore current GETs
*/

// begin global declarations

#include "grump.ch"

static getstack_ := {}       // environmental stack

// end global declarations

/*
       GFSaveGets(): save current gets and clear 'em out
*/
function GFSaveGets()
aadd(getstack_, m->getlist)
m->getlist := {}
return len(getstack_)

* end function GFSaveGets()
*--------------------------------------------------------------------*


/*
       GFRestGets(): restore last-saved gets
*/
function GFRestGets(ele)
/* use LIFO (last item in array) if no parameter was passed */
default ele to len(getstack_)
/* preclude empty array */
if len(getstack_) > 0 .and. ele <= len(getstack_)
   m->getlist := getstack_[ele]
   /* truncate length of array only if using LIFO, i.e., no param passed */
   if ele == len(getstack_) .and. pcount() = 0
      truncate(getstack_)
   endif
endif
return NIL

* end function GFRestGets()
*--------------------------------------------------------------------*

* eof gets.prg
