/*
    Program: REC_LOCK()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper reclock /n /w /a

    Attempts to lock record in multi-user environment
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

function rec_lock
local box_no, buffer, firstloop, ret_val := .f., ;
      waitmsg := "record", key := 0
if len(alias()) > 0   && no database in use
   firstloop := .t.
   do while key != K_ESC .and. ! ret_val
      if rlock()
         ret_val := .t.
      elseif firstloop
         if yes_no('Cannot lock ' + waitmsg + ' at this time', ;
                   'Would you like to wait')
            gfsaveenv(.t.)
            firstloop := .f.
            kaleid(.t., waitmsg)
         else
            exit
         endif
      else
         kaleid(.f., waitmsg)
         key := lastkey()
      endif
   enddo
   if ! firstloop
      gfrestenv()
      if ret_val    // file locked successfully - give user aural feedback
         CHARGE
      endif
   endif
endif
return (ret_val)

* end function Rec_Lock()
*--------------------------------------------------------------------*

* eof reclock.prg
