/*
    Function: GFReadLine()
    System:   GRUMPFISH LIBRARY
    Author:   Greg Lief
    Copyright (c) 1990 Grumpfish, Inc. - All Rights Reserved
    Clipper 5.x Version
    Compile instructions: clipper readline /n/w/a
    Syntax:   GFReadLine(@<cString>, <nHandle>)
    Returns:  Logical value: .T. if successful, .F. if EOF()
*/

// begin preprocessor directives

#include "fileio.ch"
#include "grump.ch"

// end preprocessor directives

#define BUFFER_SIZE    512

function gfreadline(cString, nHandle)
local lRetval := .t.
local cBuffer
local ptr
local nBytes
local cTemp
local lContinue := .t.
cString := []
do while lContinue
   cBuffer := space(BUFFER_SIZE)
   nBytes := fread(nHandle, @cBuffer, BUFFER_SIZE)
   cTemp := left(cBuffer, nBytes)
   if ( ptr := at(CRLF, cTemp) ) > 0
      cString += substr(cTemp, 1, ptr - 1)
      fseek(nHandle, -(nBytes - (ptr + 1)), FS_RELATIVE)
      exit
   // if last character was a CR, we might have inadvertently
   // split a CR/LF pair so we must check next character for LF
   elseif right(cTemp, 1) == chr(13)
      cBuffer := space(1)
      if ( nBytes := fread(nHandle, @cBuffer, 1) ) == 1
         if cBuffer == chr(10)
            cString += substr(cTemp, 1, len(cTemp) - 1)
            lContinue := .f.
         else
            cString += cTemp
            fseek(nHandle, -1, FS_RELATIVE)
         endif
      else
         cString += cTemp
         lRetval := .f.
         lContinue := .f.
      endif
   else
      cString += cTemp
      if nBytes < BUFFER_SIZE
         lRetval := .f.
         lContinue := .f.
      endif
   endif
enddo
return lRetval

* end function GFReadLine()
*--------------------------------------------------------------------*

* eof readline.prg
