/*
     Program: Rainbow()
     System: GRUMPFISH LIBRARY
     Author: Greg Lief
     Copyright (c) 1988-90, Greg Lief
     Clipper 5.01 version
     Compile instructions: clipper rainbow /n/w/a

     Display character string in continuously falling rainbow format
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

function rainbow(cstring)
static colors_ := { 'W', 'BR', 'R', 'GR', 'BG', 'B', 'G' }
local whichcolor := 0, nstart := 3, nrow, mainloop := .t.
GFSaveEnv(, 0)                  // shut off cursor
do while mainloop
   for nrow = nstart to nstart + 2
      SCRNCENTER(nrow, cstring, '+' + colors_[++whichcolor % 7 + 1] + '/N')
      if inkey(.03) != 0
         mainloop := .f.
         exit
      endif
   next
   if nstart < 18
      nstart += 3
   else
      nstart := 3
   endif
enddo
GFRestEnv()
return nil

* end function Rainbow()
*--------------------------------------------------------------------*

* eof rainbow.prg
