/*
   FUNCTION: PsychoPath()
   AUTHOR:   Greg Lief (with a name like that, was there any doubt?)
   DATE:     Tuesday, August 21, 1990
   PURPOSE:  Find a file in the DOS path
   SYNTAX:   PsychoPath(<file name to find>)
   RETURNS:  Character string: either the path in which the file
             exists, or a null string if the file was not found
             in the DOS path
   DIALECT:  Clipper 5.x
             Compile with: clipper psycho /n/w/a
*/
function PsychoPath(mfile)
local cpath := getenv("PATH") + ";", ret_val := []
local ptr := at(";", cpath)
do while ptr > 0
   ret_val := substr(cpath, 1, ptr - 1)
   ret_val := ret_val + if(right(ret_val, 1) != '\', '\', '')
   if file(ret_val + mfile)
      exit
   else
      ptr := at(";", cpath := substr(cpath, ptr + 1) )
      ret_val := []
   endif
enddo
return ret_val

* eof psycho.prg
