/*
    Program: PRINTOK()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper printok /n/w/a
    Special thanks to Robert Scher and Matt Amis for their input
    Ensures that printer is on-line before printing
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

function printok(sez)
local ret_val := .t., oldcolor, oldscrn, oldconsole
sez := (sez == NIL)    // if no parameter passed, assume use of @...says
if ! isprinter()
   oldcolor := colorset(C_ERRORMESSAGE)
   oldscrn := ShadowBox(09, 11, 14, 67, 3, 'Printer Error')
   @ 10, 13 ssay 'Common problems include: out of paper, paper jammed,'
   @ 11, 13 ssay 'off-line, printer unplugged, cable loose or unplugged'
   @ 12, 13 ssay 'Please check your printer and press any key to resume'
   @ 13, 13 ssay '(or press the Esc key to abort this print operation)'
   oldconsole := set(_SET_CONSOLE, .F.)
   do while ! isprinter() .and. lastkey() != K_ESC
      tone(MUSIC_ALERT, 1)
      tone(MUSIC_ALERT, 1)
      ginkey(0)
   enddo
   set(_SET_CONSOLE, oldconsole)
   ByeByeBox(oldscrn)
   setcolor(oldcolor)
   if lastkey() == K_ESC
      ret_val := .f.
   endif
endif
if ret_val
   if sez
      set device to print
   else
      set print on
   endif
endif
return(ret_val)

* end function PrintOK()
*--------------------------------------------------------------------*

* eof printok.prg
