/*
   Program: POPSTOP.PRG
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-93, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper popstop /n /w

    Note: For backward compatibility I have included logic to
          detect public variables GFCALCLEFT, GFCALCTOP, and
          GFCALCCOL.  If you do not need this logic, I would
          strongly advise you to recompile this with the following
          syntax, which will slightly improve performance:

          clipper popstop /n /w /dNO_PUBLICS


   Procs & Fncts: DRAWSTOPBX()

           Calls: SHADOWBOX()   (function in SHADOWB.PRG)
                  CHECKMOVE()   (function in MOVING.PRG)
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

// begin global declarations

#define ALREADY_ON   (nStartTime > 0)
static nStartTime := 0
static nStopTop := 4
static nStopLeft := 26

// end global declarations

function popstop(gfproc, line, var)
local nElapTime
local cDispTime
local hotkey := 0
local nKey := 0
local tempcolor
local bOldblock
local cOldScrn
GFSaveEnv(, 0)         // shut off cursor

// determine whether this was called via hot-key; if so, disable it
if (gfproc <> NIL)
   bOldblock := setkey(hotkey := lastkey(), NIL)
endif

#ifndef NO_PUBLICS    // see note in file header above

// use public variables to initialize position and color
if type('m->gfstopleft') <> "U"
   nStopLeft := min(m->gfstopleft, maxcol() - 28)
endif
if type('m->gfstoptop') <> "U"
   nStopTop := min(m->gfstoptop, maxrow() - 5)
endif
if type('m->gfstopcol') <> "U"
   ColorSet(C_STOPWATCH_BOX, m->gfstopcol)
endif

#endif

cOldScrn := savescreen(nStopTop, nStopLeft, nStopTop + 5, nStopLeft + 29)

drawstopbx()
// if the variable nStartTime is type numeric, it means the clock is running..
do while nKey <> K_ESC
   if ! ALREADY_ON
      @ nStopTop+2, nStopLeft+2  ssay 'Alt-B ='
      @ row()+1,    nStopLeft+2  ssay 'Bk Grnd'
      @ row(),      nStopLeft+22 ssay 'start'
      @ row()+1,    nStopLeft+6  ssay 'Press Esc to exit'
      if (nKey := ginkey(0)) = K_ALT_F10   // change color!
         tempcolor := colorpal(tempcolor, 16, if(nStopLeft > 36, 0, 64))
         // if they didn't bust out, change the stopwatch color
         if lastkey() <> K_ESC
            ColorSet(C_STOPWATCH_BOX, tempcolor)
            drawstopbx()
         endif
         loop
      endif
      if nKey < 32 .and. nKey <> K_ESC .and. nKey <> K_ENTER
         checkmove(nKey, 5, 29, @nStopTop, @nStopLeft, @cOldScrn)  // $moving.prg
         loop
      endif
   endif
   if nKey = K_ALT_B
      nStartTime := seconds()
      nKey := K_ESC     // to force exit from the main loop
   elseif nKey <> K_ESC .or. ALREADY_ON
      // use different prompts if the clock is already running...
      @ nStopTop+2, nStopLeft+2  ssay if(ALREADY_ON, '  in   ', space(7))
      @ row()+1, nStopLeft+2  ssay if(ALREADY_ON, 'bk grnd', space(7))
      @ row(),   nStopLeft+22 ssay 'stop '
      @ row()+1, nStopLeft+6  ssay if(ALREADY_ON, 'Press Esc to exit', ;
                                 replicate(chr(220), 17))
      ColorSet(C_STOPWATCH_WINDOW)
      nStartTime := if(! ALREADY_ON, seconds(), nStartTime)
      do while inkey() = 0
         nElapTime := seconds() - nStartTime
         // sound alarm at minute and hour intervals
         if nElapTime == 60.00
            tone(MUSIC_ALERT,1)
            tone(MUSIC_ALERT,1)
            tone(MUSIC_ALERT,1)
         endif
         if nElapTime == 3600.00
            tone(MUSIC_ALERT,2)
            tone(MUSIC_ALERT,2)
            nStartTime := 0
         endif
         cDispTime := str(int(nElapTime / 60), 2) + ':' + ;
                      if(nElapTime % 60 < 10, '0' + str(nElapTime % 60, 4, 2), ;
                      str(nElapTime % 60, 5, 2))
         @ nStopTop+2, nStopLeft+10 ssay cDispTime
      enddo
      ColorSet(C_STOPWATCH_BOX)
      @ nStopTop+2, nStopLeft+10 ssay cDispTime
      nKey := lastkey()
      if ! (nKey == K_ESC .and. ALREADY_ON)
         nStartTime := 0
      endif
   endif
enddo

// restore hot-key
if hotkey <> 0
   setkey(hotkey, bOldblock)
endif

// restore previous environment
restscreen(nStopTop, nStopLeft, nStopTop + 5, nStopLeft + 29, cOldScrn)
GFRestEnv()
return NIL

* end function PopStop()
*--------------------------------------------------------------------*


/*
   DrawStopBx() -- draw the stopwatch box
*/
static function drawstopbx
local cColor, ptr
ColorSet(C_STOPWATCH_BOX)
cColor := setcolor()
shadowbox(nStopTop, nStopLeft, nStopTop+4, nStopLeft+27, 5)
// determine converse of main color and use it as the title
ptr := at('/', cColor)
@ nStopTop, nStopLeft+ 9 ssay 'STOP WATCH' ;
     color substr(cColor, ptr + 1, at(',', cColor) - ptr - 1) + '/' + ;
           substr(cColor, 1, ptr - 1)
@ row()+2,  nStopLeft+ 9 ssay '0:00.00'
@ row(),    nStopLeft+19 ssay 'any key'
@ row()+1,  nStopLeft+19 ssay 'to'
SINGLEBOX(nStopTop+1, nStopLeft+9, nStopTop+3, nStopLeft+18)
return NIL

* end static function DrawStopBx()
*--------------------------------------------------------------------*

* eof popstop.prg
