/*
   Program: POPNDROP() (covers both POPBOX() and DROPBOX())
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper popbox /n/w/a

   Draws pop-up or drop-down box.  In the Summer '87 version,
   this was split into two functions.  However, it was simple
   enough to combine them into one through the use of the
   preprocessor.  The first parameter passed by the preprocessor
   is the direction: 1 = UP (popbox)  2 = DOWN (dropbox)

   Calls: BOX_TITLE()      (Function in BOXTITLE.PRG)
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function PopNDrop(ndirection, ntop, nleft, nbottom, nright, ntype, ndelay, ;
                  lshadow, ctitle, lcrossbar, cfooter)
local x, y, ret_val, z[3], boxstring
gfsaveenv(, 0)
// establish defaults if parameters were not passed
default ntop to 0
default nleft to 0
default nbottom to maxrow()
default nright to maxcol()
default ntype to 1
default ndelay to 15
default lshadow to .f.
default ctitle to []
lcrossbar := (lcrossbar != NIL)

// limit border # to 6 to avoid array crash
boxstring := BOXFRAMES[if(ntype > 6, 1, ntype)]

// establish variables and loop counter for the FOR..NEXT loop based
// upon the direction passed to this parameter (1 = up, 2 = down)
if nDirection = 1
   z := {nbottom, ntop, -1}
else
   z := {ntop, nbottom, 1}
endif

// construct array containing coordinates & contents of screen
// area underneath this box - this can be used with byebyebox()
ret_val := { ntop, nleft, nbottom + if(lshadow, 1, 0), ;
             nright + if(lshadow, 2, 0), savescreen(ntop, nleft, ;
             nbottom + if(lshadow, 1, 0), nright + if(lshadow, 2, 0)) }

// loop the loop
for x = z[1] to z[2] step z[3]
   if z[3] > 0
      @ z[1], nleft, x, nright box boxstring
   else
      @ x, nleft, nbottom, nright box boxstring
   endif
   for y = 1 to ndelay
   next
next

// draw lshadow if requested
if lshadow .and. nbottom < maxrow() .and. nright < maxcol() - 1
   gfattr(ntop + 1, nright + 1, nbottom + 1, nright + 2, 8)
   gfattr(min(nbottom + 1, maxcol()-1), nleft + 2, nbottom + 1, nright + 2, 8)
endif

// draw title if requested
if len(ctitle) > 0
   box_title(ntop, nleft, nright, ctitle, boxstring, lcrossbar)
endif

// draw footer if requested
if cfooter != NIL
   box_title(nbottom, nleft, nright, cfooter, boxstring, .f.)
endif

gfrestenv()
return (ret_val)

* end function PopBox()
*--------------------------------------------------------------------*

* eof popbox.prg
