/*
   Program: PASS_CHK()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.01 version
   Compile instructions: clipper passchk /n/w/a
   Generic password checking utility
*/

#include "grump.ch"
#include "grumpr.ch"

function Pass_Chk(cPassword, nRow, nTries)
local cPass
local lRetval := .f.
local nWidth := int((maxcol() - 3 - (16 + len(cPassword))) / 2)
local getlist := {}
local lOldscore := set(_SET_SCOREBOARD, .F.)
local oldscrn
local nCurrentTry := 0
local nCol
if nRow == NIL
   nRow := maxrow() / 2
else
   nRow := min(nRow, maxrow() - 3)
endif
default nTries to 1
gfsaveenv()
colorset(C_MESSAGE)
oldscrn := shadowbox(nRow - 1, nWidth, nRow + 1, maxcol() - nWidth, 4)
@ nRow, nWidth + 2 ssay 'Enter password:'
nCol := col() + 1
do while ++nCurrentTry <= nTries .and. ! lRetval
   cPass := space(len(cPassword))
   @ nRow, nCol gget cPass password
   read
   if ! ( lRetval := (upper(cPass) == upper(cPassword)) )
      err_msg( { 'Invalid password' } )
   endif
enddo
if ! lRetval
   err_msg( { 'Maximum number of attempts exceeded' } )
endif
byebyebox(oldscrn)
gfrestenv()
set(_SET_SCOREBOARD, lOldscore)
return lRetval

* end function Pass_Chk()
*--------------------------------------------------------------------*

* eof passchk.prg
