/*
   Program: CHECKMOVE()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1989, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper moving /n/w/a

   Called by: POPCALC()
              POPSTOP()

   Handles screen movement of desktop utility windows
   Returns Logical Value: .T. if window was moved, .F. if not

   NOT FOR USE AS A STAND-ALONE FUNCTION!!!
*/
// begin preprocessor directives

#include "inkey.ch"

// end preprocessor directives


function checkmove(nkey, topoffset, leftoffset, ntop, nleft, oldscrn)
local buffer, ret_val := .f.
if (nkey == K_UP    .and. ntop > 0) .or. ;
   (nkey == K_DOWN  .and. ntop < maxrow() - topoffset) .or. ;
   (nkey == K_LEFT  .and. nleft > 0) .or. ;
   (nkey == K_RIGHT .and. nleft < maxcol() - leftoffset) .or. ;
   nkey == K_HOME .or. nkey == K_END .or. ;
   nkey == K_PGUP .or. nkey == K_PGDN .or. ;
   nkey == K_CTRL_LEFT .or. nkey == K_CTRL_RIGHT

   dispbegin()
   // save screen image at current location
   buffer := savescreen(ntop, nleft, ntop+topoffset - 1, nleft+leftoffset - 2)
   restscreen(ntop, nleft, ntop + topoffset, nleft + leftoffset, oldscrn)

   // determine new screen coordinates for calculator box
   // first check for 'big moves' (home, end, pgup, pgdn, ^left, ^right)
   if nkey == K_HOME .or. nkey == K_END .or. nkey == K_PGUP .or. ;
            nkey == K_PGDN .or. nkey == K_CTRL_LEFT .or. nkey == K_CTRL_RIGHT
      ntop := if(nkey == K_HOME .or. nkey == K_PGUP, 0, ;
              if(nkey == K_PGDN .or. nkey == K_END, maxrow() - topoffset, ntop))
      nleft := if(nkey == K_HOME .or. nkey == K_CTRL_LEFT, 0, ;
               if(nkey == K_END .or. nkey == K_CTRL_RIGHT, ;
               maxcol() - leftoffset, nleft))
   else
      ntop -= if(nkey == K_DOWN, -1, if(nkey == K_UP, 1, 0))
      nleft -= if(nkey == K_RIGHT, -1, if(nkey == K_LEFT, 1, 0))
   endif
   oldscrn := savescreen(ntop, nleft, ntop + topoffset, nleft + leftoffset)
   gfattr(ntop+1, nleft+leftoffset-1, ntop+topoffset-1, nleft+leftoffset, 8)
   gfattr(ntop+topoffset-1, nleft+2, ntop+topoffset, nleft+leftoffset, 8)
   restscreen(ntop, nleft, ntop+topoffset-1, nleft+leftoffset-2, buffer)
   ret_val := .t.
   dispend()
endif
return ret_val

* end function CheckMove()
*--------------------------------------------------------------------*

* eof moving.prg
