/*
    Program: MENUV()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988, Greg Lief
    Clipper 5.x version
    Compile instructions: clipper menuv /n/w/a

    Creates vertical bounce-bar menu

    5.0 NOTES: MenuV() now expects a multi-dimensional array rather
               than a messy delimited character string.  The old
               (primitive) format was:

    mainmenu[1] = 'Data Entry$Edit info^DATA_ENTRY()'
    mainmenu[2] = 'Reports$Hard copies^REPORTS()'
    mainmenu[3] = 'Utilities$Misc.^UTILITIES()'
    mainmenu[4] = 'Quit$Exit to DOS'

    Out with the crud, and in with the new:

    mainmenu := { { 'Data Entry', 'Edit info', { || DATA_ENTRY() } }  , ;
                  { 'Reports', 'Hard copies', { || REPORTS() } }      , ;
                  { 'Utilities', 'Miscellaneous', { || UTILITIES() } }, ;
                  { 'Quit', 'Exit to DOS'} }

    To skip anything, just leave it NIL.  For example:

                  { 'Reports', , }  , ;

    will display Reports as a menu option, but will not display
    an accompaying message nor execute any function upon selection.
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function Menuv(aArray, cTitle, nBoxType, cBoxColor, cTitleColor, nTop, nLeft)
local nChoice
local lUseProc
local nElements := len(aArray)
local nMaxLen
local nBottom
local nRight
local gfmenuscrn
local oldcol
local xx
local cProc
local lOldMsgCtr
local nOldMsgRow
local lOldWrap
local maxrow := maxrow() + 1
local maxcol := maxcol() + 1
local lMainloop := .t.

// we will only center the prompts if the left coord was not passed
local lCenterPrompts := (nLeft == NIL)

GFSaveEnv()

// establish MESSAGE and WRAP settings
lOldMsgCtr := set(_SET_MCENTER, .T.)  // set message to be centered

// if no message row has been established already, set it to 24
if (nOldMsgRow := set(_SET_MESSAGE)) == 0
   set(_SET_MESSAGE, maxrow())
endif
lOldWrap := set(_SET_WRAP, .T.)     // SET WRAP ON

// establish defaults if parameters were not passed
default cTitle to 'Menu'
default nBoxType to 1
default cBoxColor to ColorSet(C_MENU_UNSELECTED, .T.) + ',' + ;
                  ColorSet(C_MENU_SELECTED, .T.)
default cTitleColor to ColorSet(C_MENU_SELECTED, .T.)

// limit # of menu items to 4 less than total number of rows
if nElements < maxrow - 4
   // determine maximum length for menu selections and draw box accordingly
   nMaxLen := len(cTitle) + 4  // must be at least as wide as the menu title!
   lUseProc := .f.             // set true if user passed procedures to do
   aeval(aArray, { | a | nMaxLen := max(nMaxLen, len(a[1])) } )
   // if any procedure names were passed, set lUseProc true
   lUseProc := ( ascan( aArray, { | a | a[3] <> NIL } ) > 0)

   // assign left and right column coordinates
   if nLeft == NIL
      nLeft := int((maxcol - nMaxLen) / 2)
   else
      nLeft := min(nLeft, maxcol - nMaxLen - 1)
   endif
   nRight := nLeft + nMaxLen

   // calculate top and bottom rows for box based on # of options
   if nTop == NIL
      nTop := int(maxrow/2) - int((nElements + 3) / 2)
   else
      nTop := min(nTop, maxrow - nElements - 3)
   endif
   nBottom := nTop + nElements + 2

   if nBoxType > 5
      shadowbox(nTop, nLeft-1, nBottom, nRight, (nBoxType-1) % 5 + 1, ;
                cTitle, , cBoxColor)
   else
      @ nTop, nLeft-1, nBottom, nRight box BOXFRAMES[nBoxType] color cBoxColor
      @ nTop, nLeft + int((nRight - nLeft - len(cTitle)) / 2) ;
              ssay ' ' + cTitle + ' ' color cTitleColor
   endif

   do while lMainloop
      setcolor(cBoxColor)
      // first -- display all prompts centered on the screen
      setpos(nTop + 1, nLeft)
      for xx := 1 to nElements
         @ row()+1, if(! lCenterPrompts, nLeft, ;
                       int((maxcol - len(aArray[xx][1])) / 2)) ;
                    prompt aArray[xx][1] message aArray[xx][2]
      next
      menu to nChoice
      // exit the loop if they selected the last choice, escaped, or
      // no procedures were passed to be done
      if nChoice == len(aArray) .or. nChoice == 0 .or. ! lUseProc
         lMainloop := .f.
      else
         // execute the function tied to this option if there is one
         if aArray[nChoice][3] <> NIL
            // convert to code block if not passed as code block
            if valtype(aArray[nChoice][3]) <> "B"
               cProc := &( "{ || " + aArray[nChoice][3] + "}" )
            else
               cProc := aArray[nChoice][3]
            endif
            gfmenuscrn := savescreen()
            eval(cProc)
            restscreen(,,,, gfmenuscrn)
         endif
      endif
   enddo
endif
// restore previous message and wrap settings
set(_SET_MCENTER, lOldMsgCtr)
set(_SET_MESSAGE, nOldMsgRow)
set(_SET_WRAP, lOldWrap)
GFRestEnv()
return nChoice

* end function MenuV()
*--------------------------------------------------------------------*

* eof menuv.prg
