/*
     Program: MENUH()
     System: GRUMPFISH LIBRARY
     Author: Greg Lief
     Copyright (c) 1988-90, Greg Lief
     Clipper 5.x version
     Compile instructions: clipper menuh /n/w/a
     Creates horizontal bounce-bar menu
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

// begin global declarations

#define NextItem(msg) substr(msg, 1, at("$", msg) - 1)
#define Truncate(msg) substr(msg, at("$", msg) + 1, len(msg) - at("$", msg))

// end global declarations

function menuh(nrow, ncol, spacing, prompts, messages, mcolor)
local prom, msg, choice := 1, ptr1 := 1, ptr2 := 1, oldcolor, ;
      oldmessc, oldmessrow, oldwrap
GFSaveEnv()
oldmessc := set(_SET_MCENTER, .T.)  // set message to be centered
// if no message row has been established already, use bottom row
if (oldmessrow := set(_SET_MESSAGE)) == 0
   set(_SET_MESSAGE, maxrow())
endif
oldwrap := set(_SET_WRAP, .T.)     // SET WRAP ON

default messages to ''
default mcolor to ColorSet(C_MENU_UNSELECTED, .T.) + ',' + ;
                  ColorSet(C_MENU_SELECTED, .T.)
setcolor(mcolor)
if '$' $ prompts
   prompts := trim(prompts)
   prompts := prompts + ;
                if(substr(prompts, len(prompts), 1) = '$', '', '$')
   do while ptr1 < len(prompts)
      prom := NextItem(prompts)
      @ nrow, ncol prompt prom message NextItem(messages)
      prompts := Truncate(prompts)
      messages := Truncate(messages)
      ncol += len(prom) + spacing
   enddo
   menu to choice
endif
// restore previous message and wrap settings
set(_SET_MCENTER, oldmessc)
set(_SET_MESSAGE, oldmessrow)
set(_SET_WRAP, oldwrap)
GFRestEnv()
return(choice)

* end function MenuH()
*--------------------------------------------------------------------*

* eof menuh.prg
