/*
    Program: MEMEDIT()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Special thanks to Matt Amis for his suggestions!!
    Clipper 5.01 Version
    Compile instructions: clipper memedit /n/w/a

    Procs & Fncts: MEMEDIT()
                   ESCFUNC()

    Calls: SHADOWBOX()   (function in SHADOWBO.PRG)

    Generic memo editing function
*/

#include "grump.ch"
#include "inkey.ch"
#include "memoedit.ch"
#include "setcurs.ch"

// the following three variables are file-wide static because they must
// be visible in EscFunc() below
static nMsgrow     // row at which to display "MEMO NOT UPDATED" msg
static nMsgcol     // column at which to display "MEMO NOT UPDATED" msg


function memedit(cfield, ntop, nleft, nbottom, nright, msg, lEditit)
local ret_val := .t.
local memo
local oldexact := set(_SET_EXACT, .T.)
local vartype
local oldinsert := setkey( K_INS, {|| setcursor( ;
                   if(readinsert(! readInsert()), SC_NORMAL, SC_SPECIAL1))} )
local lOldIns   := set(_SET_INSERT)
default ntop to 5
default nleft to 10
default nbottom to maxrow() - 5
default nright to maxcol() - 10
default msg to []
default lEditit to .t.

// initialize the file-wide statics (see above)
nMsgrow := ntop
nMsgcol := nright

gfsaveenv( .t. )
ColorSet(C_MEMEDIT_BOX)
Shadowbox(ntop, nleft, nbottom, nright, 1, msg, , , ;
          if(lEditit, 'Ctrl-W to save,', ' to move, or') + ' Esc to exit')
ColorSet(C_MEMEDIT_WINDOW)
scroll(ntop + 1, nleft + 1, nbottom - 1, nright - 1, 0)
// determine if this memo is a field or variable
do case
   case len(cfield) <= 10 .and. ! empty( vartype := fieldpos(cfield) )  // field
      memo := fieldget(vartype)
   case ( vartype := memvarblock(cfield) ) != NIL  // PRIVATE/PUBLIC
      memo := eval(vartype)
      vartype := .t.
   otherwise                                       // LOCAL/STATIC
      memo := cfield
      vartype := .f.
endcase
if lEditit
   // set initial cursor size based on current mode
   setcursor( if(readInsert(), SC_SPECIAL1, SC_NORMAL) )
endif
memo := memoedit(memo, ntop + 1, nleft + 1, nbottom - 1, nright - 1, ;
                 lEditit, if(lEditit, 'escfunc', ''), , 3)
// the following block is relevant only when we are editing
if lEditit
   if lastkey() != K_ESC
      do case

         // we edited a field */
         case valtype(vartype) == "N"
            if rlock()
               fieldput(fieldpos(cfield) , memo)
               unlock
            else
               err_msg( { NETERR_MSG } )
               ret_val := .f.
            endif

         // we edited a private or public variable
         case vartype
            eval( memvarblock(cfield) , memo)

         // we edited a local or static variable
         otherwise
            cfield := memo
      endcase
   else
      ret_val := .f.
   endif
endif
gfrestenv()
set(_SET_EXACT, oldexact)
setkey(K_INS, oldinsert)
set(_SET_INSERT, lOldIns)
return ret_val

* end function MemEdit()
*--------------------------------------------------------------------*


function EscFunc(stat, line, col)
// handle "ABORT Y/N" msg if Esc is hit during Memoedit
if lastkey() == K_ESC .and. (stat == 1 .or. stat == 2)
   gfsaveenv(, 0)
   @ nMsgrow, nMsgcol - 18 ssay 'MEMO NOT UPDATED'
   tone(MUSIC_ALERT, 1)
   tone(MUSIC_ALERT, 1)
   inkey(2)
   gfrestenv()
endif
return ME_DEFAULT

* end function EscFunc()
*--------------------------------------------------------------------*

* eof memedit.prg
