/*
   Function: LITE_MENU()
   System:   Grumpfish Library
   Author:   Greg Lief
   Copyright (c) 1988-90 Greg Lief
   Dialect:  Clipper 5.01
   Compile with: clipper litemenu /n/w/a
   Purpose:  Replacement for MENU TO... and ACHOICE()
   Calls:    ShadowBox()
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

// begin global declarations

static max_len

// end global declarations

function lite_menu(ntop, nleft, marray, confirmit, plaincolor, hilitcolor, ;
                   selection, ctitle, trigcolor, lrestore)
local num_elem := len(marray), xx, nkey := 0, luvletters := [], ;
      fallout := .f., oldscrn, ptr
default lrestore to .t.
default confirmit to .t.
default plaincolor to ColorSet(C_MENU_UNSELECTED, .T.)
default hilitcolor to ColorSet(C_MENU_SELECTED, .T.)
default trigcolor to "+" + ColorSet(C_MENU_SELECTED, .T.)
default selection to 1         /* set initial highlighted item */
default ctitle to ''           /* title for LITE_MENU() box */

GFSaveEnv( , 0, plaincolor )   // shut off cursor and change color
selection := min(selection, num_elem)   // preclude bound array error

// determine length of the longest menu option
max_len := len(ctitle) + 4
aeval(marray, { | a | max_len := MAX(max_len, len(strtran(a, "~", ""))) } )

// if the box coordinates were ignored, use defaults
default ntop to int((maxrow() - num_elem) / 2) - 1
default nleft to int((maxcol() + 1 - max_len) / 2)

oldscrn := shadowbox(ntop, nleft, ntop + num_elem + 1, nleft + max_len + 1, ;
                     2, ctitle)
// build the string containing available letters for selection
for xx = 1 to num_elem
   // the default is to add the first non-space character.  however,
   // if there is a tilde embedded in this menu option, use the letter
   // directly following it.
   if (ptr := at("~", marray[xx])) > 0
      luvletters += upper(substr(marray[xx], ptr + 1, 1))
   else
      luvletters += upper(substr(marray[xx], 1, 1))
   endif
   ShowOption(xx, marray[xx], ntop, nleft, plaincolor, trigcolor)
next
// commence main key-grabbing loop
do while nkey != K_ENTER .and. nkey != K_ESC
   // first display current option in highlight color
   @ ntop + selection, nleft + 1 ssay padr(strtran(marray[selection], "~", ""),;
                                     max_len) color hilitcolor
   if fallout
      exit
   else
      nkey := ginkey(0)
      do case

         // go down one option, observing wrap-around conventions
         case nkey == K_DOWN
            ShowOption(selection, marray[selection], ntop, nleft, ;
                       plaincolor, trigcolor)
            if selection = num_elem
               selection := 1
            else
               selection++
            endif

         // go up one line, observing wrap-around conventions
         case nkey == K_UP
            ShowOption(selection, marray[selection], ntop, nleft, ;
                       plaincolor, trigcolor)
            if selection = 1
               selection := num_elem
            else
               selection--
            endif

         // jump to top option
         case nkey == K_HOME
            // no point in going thru color rigmarole if we're already there
            if selection != 1
               ShowOption(selection, marray[selection], ntop, nleft, ;
                          plaincolor, trigcolor)
               selection := 1
            endif

         // jump to bottom option
         case nkey == K_END
            // no point in going thru color rigmarole if we're already there
            if selection != num_elem
               ShowOption(selection, marray[selection], ntop, nleft, ;
                          plaincolor, trigcolor)
               selection := num_elem
            endif

         // first letter - jump to appropriate option
         case upper(chr(nkey)) $ luvletters
            ShowOption(selection, marray[selection], ntop, nleft, ;
                       plaincolor, trigcolor)
            selection := at(upper(chr(nkey)), luvletters)
            /*
               if we do not need confirmation, we will set the fallout flag
               to true so that we will fall out immediately after redisplaying
               this option.  we could just as easily fall out right here, but
               it is more aesthetically pleasing to redisplay the selected
               option so that the user knows what they just selected
            */
            fallout := ! confirmit

      endcase
   endif
enddo
GFRestEnv()
if lrestore
   byebyebox(oldscrn)
endif
return (if(lastkey() == K_ESC, 0, selection))

* end function Lite_Menu()
*--------------------------------------------------------------------*


/*
  Function: ShowOption()
  Purpose:  Display current prompt in mixed colors
*/
static function showoption(noffset, coption, ntop, nleft, ccolor, ctrigger)
local ptr := at("~", coption)
if ptr > 0
   @ ntop + noffset, nleft + 1 ssay padr(strtran(coption, "~", ""), ;
                                    max_len) color ccolor
   @ ntop + noffset, nleft + ptr ssay substr(coption, ptr + 1, 1) ;
                                    color ctrigger
else
   @ ntop + noffset, nleft + 1 ssay substr(coption, 1, 1) color ctrigger
   dispout(padr(substr(coption, 2), max_len - 1), ccolor)
endif
return nil

* end static function ShowOption()
*--------------------------------------------------------------------*

* eof litemenu.prg
