/*
   Program: KALEID.PRG
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper kaleid /n/w/a

   Called by: REC_LOCK()
            : FILELOCK()
            : NET_USE()

   Draws a pretty kaleidoscope while the user
   waits for the file/record to become available
*/

// begin preprocessor directives

#include "box.ch"

// end preprocessor directives


function Kaleid(firstloop, waitmsg)
static box_no := 0, buffer, nleft, ;
       colors_ := { 'W', 'N', 'BG', 'BR', 'R', 'GR', 'B', 'G'}
box_no++
if firstloop
   waiton('waiting for ' + waitmsg + '... press Esc to abort wait')
   nleft := int(37 - len(waitmsg)) / 2
   buffer := savescreen(11, nleft, 13, nleft + 43 + len(waitmsg))
else
   @ 12 - box_no, nleft - box_no + 1, 12 + box_no, ;
       nleft + 43 + len(waitmsg) + box_no - 1 box B_SINGLE ;
       color '+w/' + colors_[int((seconds() - int(seconds())) * 8) + 1]
   inkey(.1)
   if box_no == 11
      box_no := 1
      setcolor('w/n')
      scroll()
      restscreen(11, nleft, 13, nleft + 43 + len(waitmsg), buffer)
   endif
endif
return NIL

* end function Kaleid()
*--------------------------------------------------------------------*

* eof kaleid.prg
