/*
    Program: ISSTATE()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.0 Version
    Compile instructions: clipper isstate /n/w/a
    Very special thanks to Mike Clerc for his invaluable input!

    Data validation function for State abbreviations

    Calls: APICK()      (function in APICK.PRG)
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function IsState()
static statecod_ := { "AL", "AK", "AZ", "AR", "CA", "CO", "CT", "DE", "DC", ;
                      "FL", "GA", "HI", "ID", "IL", "IN", "IA", "KS", "KY", ;
                      "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", ;
                      "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "OH", ;
                      "OK", "OR", "PA", "RI", "SC", "SD", "TN", "TX", "UT", ;
                      "VT", "VA", "WA", "WV", "WI", "WY",  NIL,  NIL, "AS", ;
                      "FM", "GU", "MP", "MH", "PW", "PR", "VI",  NIL,  NIL, ;
                      "AB", "BC", "MB", "NB", "NF", "NT", "NS", "ON", "PE", ;
                      "PQ", "SK", "YT" }
local states_ := { "Alabama", "Alaska", "Arizona", "Arkansas", ;
                    "California", "Colorado", "Connecticut", "Delaware", ;
                    "District of Columbia", "Florida", "Georgia", "Hawaii", ;
                    "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", ;
                    "Kentucky", "Louisiana", "Maine", "Maryland", ;
                    "Massachusetts", "Michigan", "Minnesota", "Mississippi", ;
                    "Missouri", "Montana", "Nebraska", "Nevada", ;
                    "New Hampshire", "New Jersey", "New Mexico", "New York", ;
                    "North Carolina", "North Dakota", "Ohio", "Oklahoma", ;
                    "Oregon", "Pennsylvania", "Rhode Island", ;
                    "South Carolina", "South Dakota", "Tennessee", "Texas", ;
                    "Utah", "Vermont", "Virginia", "Washington", ;
                    "West Virginia", "Wisconsin", "Wyoming", "~", ;
                    "~U.S. Terrorities", "American Samoa", ;
                    "Federated Micronesia", "Guam", "Mariana Islands", ;
                    "Marshall Islands", "Palau Islands", "Puerto Rico", ;
                    "Virgin Islands", "~", "~Canadian Provinces", "Alberta", ;
                    "British Columbia", "Manitoba", "New Brunswick", ;
                    "Newfoundland", "Northwest Territories", "Nova Scotia", ;
                    "Ontario", "Prince Edward Island", "Quebec", ;
                    "Saskatchewan", "Yukon" }
local ret_val := .T., element, get := getactive()
if ascan(statecod_, get:buffer) == 0
   if ! empty(get:buffer)
      keyboard trim(get:buffer)
   endif
   element := apick(6, 29, 18, 51, states_, , , , len(states_), .f., "+gr/b")
   if element = 0
      ret_val := .f.
   else
      get:varPut(statecod_[element])
      get:changed := .t.
   endif
endif
return ret_val

* end function IsState()
*--------------------------------------------------------------------*

* eof isstate.prg
