/*
    Program: HSCRNSCRL()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper vscroll /n/w/a

    Displays screen in horizontal column-by-column increments

    NOTE: screen must be pre-saved to the <screen file> using
    Save_Drape())

    Syntax: HSCRNSCRL(<screen file> [, <nDirection> ])

    Optional parameter <nDirection> determines whether display is left
    to right or vice versa.  1 = right to left, -1 = left to right.
    (Default is left-to-right.)  Thanks to Evan Davies for the
    inspiration!

    WILL HANDLE 25/43/50 ROW DISPLAYS
*/

// begin preprocessor directives

#include "fileio.ch"
#include "grump.ch"

// end preprocessor directives

function HScrnScrl(cfile, ndirection)
local maxrow := maxrow() + 1, maxcol := maxcol() + 1
local handle, screen_[maxcol], buffer, xx, yy, bufflen := maxrow * 2, buffer2
local loopers_
default ndirection to -1                // default is pull-down
if file(cfile)
   handle := fopen(cfile, FO_READ)
   if handle != F_ERROR
      // verify that this file was saved in the same mode that we are in
      // because if it wasn't, all hell will break loose further down
      if ( xx := fseek(handle, 0, FS_END) ) == maxrow * maxcol * 2 .or. ;
                                         xx == (maxrow * maxcol * 2) + 4
         fseek(handle, (xx - maxrow * maxcol * 2), FS_SET) // reset to start
         for xx = 1 to maxcol
            buffer := space(bufflen)
            fread(handle, @buffer, bufflen)
            screen_[xx] := buffer
         next
         fclose(handle)
         /*
             load LOOPERS_ array based on direction -- structure is:
                  LOOPERS_[1] := starting row for FOR..NEXT loop
                  LOOPERS_[2] := ending row for FOR..NEXT loop
                  LOOPERS_[3] := leftmost column of region to be shifted
                  LOOPERS_[4] := rightmost column of region to be shifted
                  LOOPERS_[5] := column to be newly displayed
         */
         if ndirection == 1
            loopers_ := { 1, maxcol, 1, maxcol - 1, maxcol }
         else
            loopers_ := { maxcol, 1, 0, maxcol - 2, 0 }
         endif
         for xx = loopers_[1] to loopers_[2] step ndirection
            buffer2 := savescreen(0, loopers_[3], maxrow - 1, loopers_[4])
            restscreen(0, loopers_[5],  maxrow - 1,  loopers_[5], screen_[xx])
            restscreen(0, loopers_[3] - ndirection,  maxrow - 1, ;
                          loopers_[4] - ndirection, buffer2)
         next
      endif
   endif
endif
return NIL

* end function HScrnScrl()
*--------------------------------------------------------------------*

* eof hscroll.prg
