/*
   Program: HELPBROW()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.01 Version
   Compile instructions: clipper helpbrow /n/w/a

       Calls: SHADOWBOX()  (function in SHADOWBO.PRG)
              ERR_MSG()    (function in ERRORMSG.PRG)

   Interactive help for data validation
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

function helpbrow(s_area, field1, head1, field2, head2, editable, ;
         boxcolor, sayrow, saycol, ntop, nleft, nbottom, nright, bAction, ;
         bPostAction)
local oldcolor
local wk_area := select()
local buffer
local buffer2
local key
local browse
local column
local marker
local searchstr
local lOldscore
local mwidth := 2
local oldscrn
local oldf10
local ntoprow
local nleftcol
local cdescrip
local msg
local mainloop
local lHad2Open := .f.
local oGet := getactive()
local curr_var := oGet:varGet()
local getlist := {}
local lRetval := .t.
local bOldUp
local bOldDown

default editable to (field2 <> NIL)
default head1 to field1
default field2 to nil

// make sure lookup database is already open -- if not, open it!
if select(s_area) == 0
   if file(s_area + '.dbf')
      lHad2Open := .t.    // so we know to close the file on the way out
      use (s_area) new
   else
      // Programmer error!  Where's that rascally lookup table??
      err_msg( { "Could not locate file " + s_area + ".dbf" } )
      return .t.
   endif
else
   select(select(s_area))
endif

// note: many people use HELPBROW() in conjunction with GRUMPBROW(),
// which remaps the UP and DOWN arrows to do something completely
// different.  Therefore, we will temporarily shut them off so that
// they do what we expect them to do in the context of this function.
bOldUp   := setkey(K_UP, NIL)
bOldDown := setkey(K_DOWN, NIL)
GFSaveEnv()
lOldscore := set(_SET_SCOREBOARD, .f.)   // I despise it!

// check for existence of index file - if none, resort to LOCATE (ugh!)
if indexord() = 0
   locate for fieldget(fieldpos(field1)) == curr_var
else
   searchstr := []     // initialize search string for use below
   // use softseek to position record pointer at closest hit
   dbseek(curr_var, .t.)
endif
if ! found()
   // if we're at the very bottom of the file, jump up
   if eof()
      go top
   endif
   // shut off F10 if it is configured as a hot-key because we need it
   oldf10 := setkey(K_F10, NIL)
   setcursor(0)       // shut off cursor - already saved by GFSaveEnv()
   /*
      if we are not using an index, go back to the top
      if we are using an index, we don't want to mess
      with the record pointer because it is better to
      leave it at the nearest matching record
   */
   if searchstr == NIL
      go top
   endif
   default boxcolor to ColorSet(C_APICK_BOXOUTLINE, .T.)
   // determine necessary width of fields/headings for box
   mwidth += max(len(head1), if(type(field1) == "C", ;
             len(fieldget(fieldpos(field1))), ;
             len(str(fieldget(fieldpos(field1))))))
   if field2 <> NIL
      mwidth += max(len(head2), if(type(field2) == "C", ;
             len(fieldget(fieldpos(field2))), ;
             len(str(fieldget(fieldpos(field2))))))
   endif
   /*
      establish box coordinates if not passed as parameters
      notice that coordinates are dynamic based upon the
      width (calculated above) and # of fields in database
   */
   default ntop to max(6, 12 - lastrec() / 2)
   default nleft to int(((maxcol() + 1) - mwidth) / 2)
   default nright to nleft + mwidth
   default nbottom to min(maxrow() - if(editable, 4, 3), ntop + 3 + lastrec())

   browse := TBrowseDB(ntop + 1, nleft + 1, nbottom - 1, nright - 1)
   browse:headSep := ""
   browse:colorSpec := boxcolor + ',' + ColorSet(C_APICK_CURRENT, .T.)
   column := TBColumnNew(head1, fieldblock(field1) )
   column:width := max(len(head1), if(type(field1) == "C", ;
             len(fieldget(fieldpos(field1))), ;
             len(str(fieldget(fieldpos(field1))))))
   browse:addColumn(column)
   if field2 <> NIL
      column := TBColumnNew(head2, fieldblock(field2) )
      column:width := max(len(head2), if(type(field2) == "C", ;
             len(fieldget(fieldpos(field2))), ;
             len(str(fieldget(fieldpos(field2))))))
      browse:addColumn(column)
   endif
   oldcolor := setcolor(boxcolor)
   oldscrn := savescreen(0, 0, maxrow(), maxcol())
   shadowbox(ntop, nleft, nbottom, nright, 1)
   nleftcol := int( (maxcol() - 62) / 2)
   ntoprow := maxrow() - if(searchstr == NIL, 2, 3) - if(editable, 1, 0)
   SINGLEBOX(ntoprow, nleftcol, maxrow(), maxcol() - nleftcol)
   SCRNCENTER(ntoprow + 1, "Move highlight bar to desired value and " + ;
                       "press Enter to select")
   if editable
      SCRNCENTER(row() + 1, "Press F10 to add '" + ;
             if(valtype(curr_var) = "N", ltrim(str(curr_var)), curr_var) + ;
             "' as a new code")
   endif
   if searchstr <> NIL
      SCRNCENTER(row() + 1, "Type first few letters to jump to desired value")
   endif
   mainloop := .t.
   do while mainloop
      dispbegin()
      do while ( key := inkey() ) == 0 .and. ! browse:stabilize()
      enddo
      dispend()

      if browse:stable
         // execute code block if one was passed...
         if valtype(bAction) == "B"
            eval(bAction)
         endif
         key := ginkey(0, "KEY")
      endif

      // deal with the keypress
      do case

         case key == K_UP
            browse:up()

         case key == K_LEFT
            browse:left()

         case key == K_RIGHT
            browse:right()

         case key == K_DOWN
            browse:down()

         case key == K_CTRL_PGUP
            browse:goTop()

         case key == K_CTRL_PGDN
            browse:goBottom()

         case key == K_PGUP .or. key == K_HOME
            browse:pageUp()

         case key == K_PGDN .or. key == K_END
            browse:pageDown()

         case key == K_F10 .and. editable .and. field2 <> NIL
            cdescrip := space(len(fieldget(fieldpos(field2))))
            msg := "Enter description for code '" + ;
                   if(valtype(curr_var) == "N", ;
                   ltrim(str(curr_var)), curr_var) + "'"
            nleftcol := max(0, int((maxcol() - len(msg + cdescrip) - ;
                        if(set(_SET_DELIMITERS), 4, 2)) / 2) )
            buffer2 := ShadowBox(11, nleftcol, 13, maxcol() - nleftcol, 2)
            @ 12, nleftcol + 1 ssay msg
            if len(msg + cdescrip) > maxcol() - 2
               @ row(), col() + 1 get cdescrip picture '@S' + ;
                                  str(maxcol() - 2 - len(msg), 2)
            else
               @ row(), col() + 1 get cdescrip
            endif
            setcursor(2)
            read
            setcursor(0)
            ByeByeBox(buffer2)
            if ! empty(cdescrip)
               append blank
               if ! neterr()
                  fieldput(fieldpos(field1), curr_var)
                  fieldput(fieldpos(field2), cdescrip)
               else
                  err_msg( { NETERR_MSG } )
               endif
               mainloop := .F.
            endif

         case key == K_ENTER
            oGet:varPut(fieldget(fieldpos(field1)))
            oGet:changed := .t.
            mainloop := .F.
            // execute post-processing code block if applicable
            if valtype(bPostAction) == "B"
               eval(bPostAction)
            endif

         case key == K_ESC
            mainloop := .F.
            lRetval := .F.

         case ( key > 31 .and. key < 255 ) .and. searchstr <> NIL   // search
            marker := recno()
            seek searchstr + chr(key)
            if eof()
               go marker
            else
               searchstr += CHR(key)
               browse:refreshAll()
            endif

         case key == K_BS .and. searchstr <> NIL   // truncate search string
            if len(searchstr) > 0
               searchstr := substr(searchstr, 1, len(searchstr) - 1)
               seek searchstr
               browse:refreshAll()
            endif

      endcase
   enddo
   setkey(K_F10, oldf10)   // reset F10 keypress to its previous setting
   setcolor(oldcolor)
   restscreen(0, 0, maxrow(), maxcol(), oldscrn)
endif
// display look-up description if you asked for it
if sayrow <> NIL .and. saycol <> NIL
   @ sayrow, saycol ssay fieldget(fieldpos(field2))
endif
// close lookup database if we had to open it
if lHad2Open
   use
endif
// clean up
select(wk_area)
set(_SET_SCOREBOARD, lOldscore)
GFRestEnv()
setkey(K_UP, bOldUp)
setkey(K_DOWN, bOldDown)
return lRetval

* end function HelpBrow()
*--------------------------------------------------------------------*

* eof helpbrow.prg
