/*
     Program: HBLINDS.PRG
     System: GRUMPFISH LIBRARY
     Author: Greg Lief
     Copyright (c) 1988-90, Greg Lief
     Clipper 5.x version
     Compile instructions: clipper hblinds /n/w/a

     Procs & Fncts: HBLINDOPEN()
                  : HBLINDCLOS()
                  : HBLINDSAVE()

     NOTE: These three functions support 25 and 50 line display only!
*/

// begin preprocessor directives

#include "grump.ch"
#include "fileio.ch"

// end preprocessor directives

/*
    Function: HBLINDOPEN()
    Purpose:  Draw title screen using horizontal blinds effect
    NOTE:     Title screen must be pre-saved using HBLINDSAVE()
    Syntax:   Hblindopen(<name of screen file>, [<delay>])
              Default delay is 15 - change it to suit your hardware
*/
function hblindopen(cfile, ndelay)
local nhandle, screen_[maxrow() + 1], nbufferlen := (maxcol() + 1) * 2, ;
      maxrow := maxrow() + 1, maxcol := maxcol() + 1, xx, yy, buffer
default ndelay to 15
// sorry -- cannot currently accommodate 43-line mode (25 or 50 only)
// this is because 43 happens to be a prime number, and thus causes
// problems when we attempt to evenly divide the display intervals
if maxrow != 43
   if file(cfile)
      nhandle = fopen(cfile, FO_READ)
      // verify that this file was saved in the same mode that we are in
      // because if it wasn't, all hell will break loose further down
      if fseek(nhandle, 0, FS_END) == maxrow * maxcol * 2
         fseek(nhandle, 0, FS_SET)       && reset to start of file
         for xx = 1 to maxrow
            buffer := space(nbufferlen)
            fread(nhandle, @buffer, 160)
            screen_[xx] := buffer
         next
         fclose(nhandle)
         for xx = 4 to 0 step -1
            for yy = (maxrow / 6.25) to 0 step -1
               restscreen(yy*5 + xx, 0, yy*5 + xx, maxcol-1, screen_[yy*5+xx+1])
            next
            for yy = 1 to ndelay
            next
         next
      endif
   endif
endif
return NIL

* end function HBlindOpen()
*--------------------------------------------------------------------*

/*
    Function: HBLINDCLOS()
    Purpose:  Clear screen using horizontal blinds effect
    Syntax:   Hblindclos([<delay>])
              Default delay is 30 - change it to suit your hardware
*/
function hblindclos(ndelay)
local xx, yy, maxrow := maxrow() + 1, maxcol := maxcol()
default ndelay to 30
for xx = 0 to 4
   for yy = 0 to maxrow / 6.25
      scroll(yy * 5 + xx, 0, yy * 5 + xx, maxcol, 0)
   next
   for yy = 1 to ndelay
   next
next
return NIL

* end function HBlindClos()
*--------------------------------------------------------------------*


/*
    Function: HBLINDSAVE()
    Purpose:  Save title screen to specified memory file
    Syntax:   HBlindSave(<name of screen file>)
*/
function hblindsave(cfile)
local buffer, handle := fcreate(cfile, FC_NORMAL), xx, ret_val := .f., ;
      maxrow := maxrow(), maxcol := maxcol()
if ferror() = 0
   ret_val := .t.
   for xx = 0 to maxrow
      buffer := savescreen(xx, 0, xx, maxcol)
      if fwrite(handle, buffer) != (maxcol + 1) * 2
         ret_val := .f.
         exit
      endif
   next
   fclose(handle)
endif
return ret_val

* end function HBlindSave()
*--------------------------------------------------------------------*

* eof hblinds.prg
