; File......: SHADOW.ASM
; Author....: Ted Means
; Date......: $Date:
; Revision..: $Revision:
; Log file..: $Logfile:
; 
; This is an original work by Ted Means and is placed in the public domain.
;
;  SYNTAX
;
;     GFAttr( <nTop>, <nLeft>, <nBottom>, <nRight>, <nAttr> ) -> NIL
;
;  ARGUMENTS
;     <nTop>    is the top row of the shadow area.
;     <nLeft>   is the upper left column of the shadow area.
;     <nBottom> is the bottom row of the shadow area.
;     <nRight>  is the lower right column of the shadow area.
;     <nAttr>   is the screen attribute to use for drawing the shadow.
;
;  RETURNS
;     NIL
;
;  DESCRIPTION
;
;     This function allows you to implement the popular "shadow effect."  It
;     draws a shadow along the bottom and right side of the specified area.
;     If the shadow exceeds the boundaries of the screen, it does not wrap
;     to the next line; instead it is truncated.
;
;     *** INTERNALS ALERT ***  This function uses several Clipper internal 
;     routines.  If using internals scares you, then stay away from this
;     function, you gutless weasel.  The use of the internals helps to make
;     the function more well-behaved.  Clipper's display context is not
;     violated -- if you use dispbegin() before drawing the shadow, it will
;     not appear until the corresponding call to dispend().  This makes for
;     much smoother screen i/o if you have several screen objects that
;     you wish to shadow.
;
;     The source code is written to TASM IDEAL mode.
;
;  EXAMPLES
;     GFAttr(10,10,20,50, 8)  // draw a dim shadow
;     GFAttr(10,20,20,40,47)  // draw a green shadow
;     RETURN

IDEAL

Public   GFAttr

Extrn    __ParNI:Far
Extrn    __RetL:Far
Extrn    __gtSave:Far                        ; ** INTERNAL **
Extrn    __gtRest:Far                        ; ** INTERNAL **
Extrn    __vAlloc:Far                        ; ** INTERNAL **
Extrn    __vLock:Far                         ; ** INTERNAL **
Extrn    __vUnlock:Far                       ; ** INTERNAL **
Extrn    __vFree:Far                         ; ** INTERNAL **

nTop     EQU       Word Ptr BP - 2
nLeft    EQU       Word Ptr BP - 4
nBottom  EQU       Word Ptr BP - 6
nRight   EQU       Word Ptr BP - 8
nAttr    EQU       Byte Ptr BP - 10
nSize    EQU       Word Ptr BP - 12
nHandle  EQU       Word Ptr BP - 14
cBuffer  EQU       DWord Ptr BP - 18
nBufOfs  EQU       Word Ptr BP - 18
nBufSeg  EQU       Word Ptr BP - 16

Segment  _Grump   Word      Public    "CODE"
         Assume    CS:_Grump

Proc     GFAttr    Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,18                     ; Allocate locals

         Mov       CX,5                      ; Set param count
Coord:   Push      CX                        ; Put on stack
         Call      __ParNI                   ; Retrieve param
         Pop       CX                        ; Get count back
         Push      AX                        ; Put value on stack
         Loop      Coord                     ; Get next value

         Pop       [nTop]                    ; Get top coordinate
         Pop       [nLeft]                   ; Get left coordinate
         Pop       [nBottom]                 ; Get bottom coordinate
         Pop       [nRight]                  ; Get right coordinate
         Pop       [Word Ptr BP - 10]        ; Get attribute

         Mov       AX,[nBottom]              ; Load bottom coordinate
         Sub       AX,[nTop]                 ; Subtract top
         Inc       AX                        ; Calc length

         Mov       DX,[nRight]               ; Load right coordinate
         Sub       DX,[nLeft]                ; Subtract left
         Inc       DX                        ; Calc width
         Mul       DX                        ; Calc buffer size
         Mov       [nSize],AX
         SHL       AX,1                      ; Account for attribute bytes
         Push      AX                        ; Put size on stack
         Call      __vAlloc                  ; Allocate virtual memory
         Mov       [nHandle],AX              ; Store handle
         Or        AX,AX
         JZ        Exit

         Push      AX                        ; Put handle on stack
         Call      __vLock                   ; Convert handle to pointer
         Mov       [nBufSeg],DX              ; Store segment
         Mov       [nBufOfs],AX              ; Store offset

         Push      [nBufSeg]                 ; Put buffer segment on stack
         Push      [nBufOfs]                 ; Put buffer offset on stack
         Push      [nRight]
         Push      [nBottom]                 ; Get bottom coordinate
         Push      [nLeft]
         Push      [nTop]                    ; Get top row
         Call      __gtSave                  ; Save screen image

         Mov       AL,[nAttr]                ; Get attribute
         Mov       CX,[nSize]                ; Get length
         Push      DI                        ; Save DI
         LES       DI,[cBuffer]              ; Load pointer to buffer
Top:     Inc       DI                        ; Point to attribute byte
         Stosb                               ; Set attribute
         Loop      Top                       ; Do next byte
         Pop       DI                        ; Restore DI
         Call      __gtRest                  ; Put shadowed image on screen

Done:    Push      [nHandle]                 ; Put handle on stack
         Call      __vUnlock                 ; Unlock handle
         Call      __vFree                   ; Free handle
         Mov       AX,1                      ; Set return value to .T.

Exit:    Push      AX
         Call      __RetL
         Mov       SP,BP                     ; Realign stack
         Pop       BP                        ; Restore BP
         Ret
Endp     GFAttr
Ends     _Grump
End

