/*
    Function: GKeyStep()
    Purpose:  Alternate for GetApplyKey() for step entry (dates and numerics)
    Author:   Greg Lief
    Copyright (c) 1991 Greg Lief
    Dialect:  Clipper 5.01
*/

#include "grump.ch"
#include "inkey.ch"
#include "getexit.ch"

// these manifest constants are necessary for enhanced keyboard
// (i.e., the @..GGET STEP ENHANCED command)
#ifndef K_CTRL_KMINUS
   #define K_CTRL_KMINUS           398     // * Keypad Ctrl--
   #define K_CTRL_KPLUS            400     // * Keypad Ctrl-+
#endif

procedure gkeystep(get, key, nstep, lEnhanced)
local oldvalue
default lEnhanced to .f.
// check for SET KEY and basic movement keys
if ! GKeyBasic(get, key)
   do case

      case (key == K_INS)
         Set( _SET_INSERT, ! Set(_SET_INSERT) )
         setcursor( if(set(_SET_INSERT), 3, 1) )

      case (key == K_CTRL_U)
         get:Undo()

      case (key == K_HOME)
         get:Home()

      case (key == K_END)
         get:End()

      case (key == K_RIGHT)
         get:Right()

      case (key == K_LEFT)
         get:Left()

      case (key == K_CTRL_RIGHT)
         get:WordRight()

      case (key == K_CTRL_LEFT)
         get:WordLeft()

      case (key == K_BS)
         get:BackSpace()

      case (key == K_DEL)
         get:Delete()

      case (key == K_CTRL_T)
         get:DelWordRight()

      case (key == K_CTRL_Y)
         get:DelEnd()

      case (key == K_CTRL_BS)
         get:DelWordLeft()

      otherwise

         if (key >= 32 .and. key <= 400)
            // test for step entry on numerics and dates
            if ( key == if(lEnhanced, K_CTRL_KPLUS, 43) .or. ;
                 key == if(lEnhanced, K_CTRL_KMINUS, 45) ) .and. ;
                       get:type $ "ND"
               default nstep to 1
               get:changed := .t.
               oldvalue := get:varGet()
               if key == if(lEnhanced, K_CTRL_KMINUS, 45)
                  get:varPut(oldvalue - nStep)
               else
                  get:varPut(oldvalue + nStep)
               endif
               if get:postBlock != NIL .and. ! eval(get:postBlock, get)
                  get:varPut(oldvalue)
               endif
               get:updateBuffer()
            else
               if ( Set(_SET_INSERT) )
                  get:Insert(chr(key))
               else
                  get:Overstrike(chr(key))
               endif
               if (get:typeOut .and. !Set(_SET_CONFIRM) )
                  if ( Set(_SET_BELL) )
                     ?? Chr(7)
                  endif
                  get:exitState := GE_ENTER
               endif
            endif
         endif
   endcase
endif
return
