/*
    Function: GKeyProper()
    Purpose:  Alternate for GetApplyKey() for proper-case data entry
    Author:   Greg Lief
    Copyright (c) 1991 Greg Lief
    Dialect:  Clipper 5.01
*/

#include "inkey.ch"
#include "getexit.ch"

/*
  Whenever any characters in SEPARATORS are detected, the
  next character entered will be forced to upper-case.  If
  you want to use other characters, make the change here.
*/
#define SEPARATORS  " -',."
#xtranslate TestBuffer() => (substr(get:buffer, get:pos - 1, 1) $ SEPARATORS)

procedure gkeyproper(get, key)
static forceupper := .t.
local cKey
// check for SET KEY and basic movement keys
if ! GKeyBasic(get, key)
   do case
      case (key == K_INS)
         Set( _SET_INSERT, ! Set(_SET_INSERT) )
         setcursor( if(set(_SET_INSERT), 3, 1) )

      case (key == K_CTRL_U)
         get:Undo()
         forceupper := .t.        // reset flag for next time

      case (key == K_HOME)
         get:Home()
         forceupper := .t.

      case (key == K_END)
         get:End()
         forceupper := .f.

      case (key == K_RIGHT)
         get:Right()
         forceupper := TestBuffer()

      case (key == K_LEFT)
         get:Left()
         // if we just backspaced to the start of a word or the string,
         // we must reset the flag to force next character upper-case
         forceupper := (get:pos==1 .or. TestBuffer())

      case (key == K_CTRL_RIGHT)
         get:WordRight()
         forceupper := .t.  // cause we are at the beginning of a word

      case (key == K_CTRL_LEFT)
         get:WordLeft()
         forceupper := .t.  // cause we are at the beginning of a word

      case (key == K_BS)
         get:BackSpace()
         /*
            if we just backspaced to the start of a word, or
            the start of the string, we must reset the flag to
            force the next character to be upper-case
         */
         forceupper := (get:pos==1 .or. TestBuffer())

      case (key == K_DEL)
         get:Delete()

      case (key == K_CTRL_T)
         get:DelWordRight()

      case (key == K_CTRL_Y)
         get:DelEnd()

      case (key == K_CTRL_BS)
         get:DelWordLeft()
         forceupper := .t.

      otherwise

         if (key >= 32 .and. key <= 255)
            cKey := Chr(key)
            if ckey $ SEPARATORS
               forceupper := .t.  // next char will be uppercase
            elseif key > 64
               if forceupper
                  /* if the next character should be upper but they
                     entered an upper, switch case to lower: huh?
                     this is so that someone could enter, say,
                     "dBASE" (not that they'd really want to!)
                  */
                  if key < 91
                     ckey := chr(key + 32)
                  else   /* force upper-case if necessary */
                     ckey := chr(key - 32)
                  endif
                  forceupper := .f.
               endif
            endif
            if ( Set(_SET_INSERT) )
               get:Insert(cKey)
            else
               get:Overstrike(cKey)
            endif
            if (get:typeOut .and. !Set(_SET_CONFIRM) )
               if ( Set(_SET_BELL) )
                  ?? Chr(7)
               endif
               get:exitState := GE_ENTER
            endif
         endif
   endcase
else
   forceupper := .t.
endif
return
