/*
    Function: GKeyPass()
    Purpose:  Alternate for GetApplyKey()
              for password entry
    Author:   Greg Lief
    Copyright (c) 1991 Greg Lief
    Dialect:  Clipper 5.01
*/

#define  PASSWORD       cargo[2, 1]
#define  PASSWIDTH      cargo[2, 2]
#define  PASSCHAR       substr(get:picture, 3)

#include "inkey.ch"
#include "getexit.ch"

procedure gkeypass(get, key)
local cKey
local oldvalue

// check for SET KEY and basic movement keys
if ! GKeyBasic(get, key)

   do case

      case (key == K_INS)
         Set( _SET_INSERT, ! Set(_SET_INSERT) )
         setcursor( if(set(_SET_INSERT), 3, 1) )

      case (key == K_CTRL_U)
         get:Undo()

      case (key == K_BS)
         get:BackSpace()
         get:PASSWORD := substr(get:PASSWORD, 1, len(get:PASSWORD) - 1)

      otherwise

         if (key >= 32 .and. key <= 255)
            cKey := chr(key)
            // we keep the real string in the cargo hold and display asterisks
            get:PASSWORD += ckey
            if ( Set(_SET_INSERT) )
               get:Insert(PASSCHAR)
            else
               get:Overstrike(PASSCHAR)
            endif
            if (get:typeOut .and. !Set(_SET_CONFIRM) )
               if ( Set(_SET_BELL) )
                  ?? Chr(7)
               endif
               get:exitState := GE_ENTER
            endif
         endif
   endcase
endif
return
