/*
    Function: GKeyList()
    Purpose:  Alternate for GetApplyKey()
              for list clause
    Author:   Greg Lief
    Copyright (c) 1991 Greg Lief
    Dialect:  Clipper 5.01
*/

#include "inkey.ch"
#include "getexit.ch"

#define VALUES        get:cargo[3]
#define POINTER       get:cargo[4]

procedure gkeylist(get, key)
local cKey
local oldvalue

// check for SET KEY and basic movement keys
if ! GKeyBasic(get, key)

   do case

      case (key == K_CTRL_U)
         get:Undo()

      case (key == K_BS)
         if POINTER == 1
            POINTER := len(VALUES)
         else
            POINTER--
         endif
         // must pad the buffer to maximum length so as to
         // avoid leftover flotsam from previous item
         get:changed := .t.
         get:varPut(padr(VALUES[POINTER], len(get:picture)))
         get:updateBuffer()

      case (key == 32)
         if POINTER == len(VALUES)
            POINTER := 1
         else
            POINTER++
         endif
         // must pad the buffer to maximum length so as to
         // avoid leftover flotsam from previous item
         get:changed := .t.
         get:varPut(padr(VALUES[POINTER], len(get:picture)))
         get:updateBuffer()

   endcase
endif
return
