/*
    Function: GKillGet()
    Purpose:  Remove a GET from the getlist array
    Author:   Greg Lief
    Dialect:  Clipper 5.x
    Copyright (c) 1991 Greg Lief
*/
#include "grump.ch"

function gkillget(victim, getlist)
local ele
default getlist to m->getlist
do case

   case valtype(victim) == 'C'
      ele := ascan(getlist, { | a | upper(victim) $ upper(a:name) } )

   case valtype(victim) == 'N'
      if victim > len(getlist)
         ele := len(getlist)
      else
         ele := max(victim, 1)
      endif

   otherwise
      ele := ascan(getlist, { | a | getactive():name $ a:name } )

endcase
if ele > 0
   asize(adel(getlist, ele), len(getlist) - 1)
endif
return (ele > 0)

* eof GKILLGET.PRG
