/*
    Function: GKeyCalc()
    Purpose:  Alternate for GetApplyKey()
              for calculator-style data entry only
    Author:   Greg Lief
    Copyright (c) 1991 Greg Lief
    Dialect:  Clipper 5.01
*/

#define  MAX_DECIMAL     get:cargo[3, 1]
#define  CURR_DECIMAL    get:cargo[3, 2]
#define  ALREADYVISITED  get:cargo[3, 3]

#include "inkey.ch"
#include "getexit.ch"

procedure gkeycalc(get, key)
local cKey

// check for SET KEY and basic movement keys
if ! GKeyBasic(get, key)
   do case

      case (key == K_BS)
         get:BackSpace()
         if val(get:buffer) != 0 .or. CURR_DECIMAL > 0
            do case
               /* number is integer, kill least significant digit */
               case CURR_DECIMAL == 0
                  get:varPut( int( get:varGet() / 10) )
               /* one decimal place: scrub decimal point */
               case CURR_DECIMAL == 2
                  CURR_DECIMAL := 0
                  get:varPut( int( get:varGet() ) )
               otherwise
                  CURR_DECIMAL--
                  get:varPut(val(substr(get:buffer, 1, ;
                           get:decpos + CURR_DECIMAL - 1)))
            endcase
            get:updateBuffer()
         endif

      otherwise

         if ( ckey := chr(key) ) $ '.0123456789-'
            // we must change the g:changed instance variable
            // manually, because g:varPut() won't do it for us
            get:changed := .t.
            if ALREADYVISITED
               ALREADYVISITED := .F.
               get:varPut(0)
            endif
            do case

               case cKey == '-'      /* positive to negative */
                  get:varPut(get:varGet() * -1)

               case cKey == '.' .and. CURR_DECIMAL == 0
                  CURR_DECIMAL++

               case get:varGet() != 0 .and. CURR_DECIMAL == 0 .and. ;
                               left(get:buffer, 1) == ' '
                  get:varPut(get:varGet() * 10 + val(cKey) * ;
                           if(get:varGet() < 0, -1, 1))

               case CURR_DECIMAL > 0 .and. ;
                    CURR_DECIMAL <= MAX_DECIMAL
                  get:varPut(get:varGet() + ;
                        (val(cKey) / (10 ^ CURR_DECIMAL++)) * ;
                        if(get:varGet() < 0, -1, 1))

               case get:varGet() == 0
                  get:varPut(val(cKey))
            endcase
            get:updateBuffer()
         endif
   endcase
endif
return
