/*
    Function: GKeyBasic()
    Purpose:  test for hot keys and all basic keys used for exiting GETs
              this is a separate function so that the code need not be
              duplicated in each special keypress module
    Author:   Greg Lief
    Copyright (c) 1991 Greg Lief
    Dialect:  Clipper 5.01
*/

#include "inkey.ch"
#include "getexit.ch"

function GKeyBasic( get, key )
local bKeyBlock := SetKey(key)
local ret_val := .t.
// check for SET KEY first
if bKeyBlock != NIL
   GetDoSetKey(bKeyBlock, get)
else
   do case

      case ( key == K_UP )
         get:exitState := GE_UP

      case ( key == K_SH_TAB )
         get:exitState := GE_UP

      case ( key == K_DOWN )
         get:exitState := GE_DOWN

      case ( key == K_TAB )
         get:exitState := GE_DOWN

      case ( key == K_ENTER )
         get:exitState := GE_ENTER

      case ( key == K_ESC )
         if ( Set(_SET_ESCAPE) )
            get:undo()
            get:exitState := GE_ESCAPE
         endif

      case ( key == K_PGUP )
         get:exitState := GE_WRITE

      case ( key == K_PGDN )
         get:exitState := GE_WRITE

      case ( key == K_CTRL_HOME )
         get:exitState := GE_TOP

      // both ^W and ^End terminate the READ (the default)
      case (key == K_CTRL_W)
         get:exitState := GE_WRITE

      otherwise
         ret_val := .f.
   endcase
endif
return (ret_val)
