/*
     Program: GINKEY()
     System: GRUMPFISH LIBRARY
     Author: Greg Lief
     Copyright (c) 1988-90, Greg Lief
     Clipper 5.x Version
     Compile instructions: clipper inkey /n/w/a

     Replacement for INKEY() that tests for SET KEY procedures

     Syntax:  GINKEY( <nWaittime> [, <cVarname>], [ <xData> ] )

              <nWaittime> - number of seconds to wait for keypress
                            before automatically timing out

              <cVarname>  - variable name to pass as third parameter
                            to any hot-key procedure (default:
                            "GINKEY")

              <xData>     - extra data of any type to be passed as
                            4th parameter to any hot-key procedure
                            (used by Grumpbrow() to pass the TBrowse
                            object)
*/

#include "grump.ch"

function ginkey(nWait, cVarname, xData)
local key, cblock, loopy := .t.
local nstart, ntimeout, bevent, bexit      // used for timeout loop
do while loopy
   do case
      // if no WAITTIME passed, go straight through */
      case nWait == NIL
         key := inkey()
      case nWait == 0
         ntimeout := ginkeytime(GINKEYTIME)
         nstart := seconds()
         bevent := ginkeytime(GINKEYEVENT)
         do while (key := inkey()) == 0 .and. seconds() - nstart < ntimeout
            if bevent != NIL
               eval(bevent)
            endif
         enddo
         if key == 0                            // we timed out!
            // if no exitevent was specified, use screen blanker
            if (bexit := ginkeytime(GINKEYEXIT)) == NIL
               blankscr3(-1)
            else
               eval(bexit)
            endif
            loop
         endif
      otherwise
         key := inkey(nWait)
   endcase
   cblock := setkey(key)
   if cblock != NIL
      // run the code block associated with this key and pass it the
      // name of the previous procedure and the previous line number
      eval(cblock, procname(1), procline(1), ;
           if(cVarname == NIL, 'GINKEY', cVarname), xData)
   else
      loopy := .f.
   endif
enddo
return key

// end function GInkey()
*--------------------------------------------------------------------*

/*
     Function: GInkeyTime()
     Author:   Greg Lief
     Copyright (c) 1991 Greg Lief
     Purpose:  Retrieve or assign the number of seconds at which to
               time out of the GINKEY(0) wait state due to inactivity.
               This function also retrieves or assigns the event to
               process in the event of such a time-out
     Syntax:   GInkeyTime(<nItem> [, <newvalue>])
     Params:   <nItem> is the item to poll or change.  This setting
               will be changed only if <newvalue> is passed.

               1 = nSeconds (number of seconds to wait for timeout)
               2 = bEvent (code block to evaluate during wait loop)
               3 = bExitEvent (code block to evaluate after timeout)

     Returns:  Current setting of <nItem>
*/
function ginkeytime(nitem, newvalue)
static settings_ := { 600000, , }
local ret_val
if nitem != NIL
   ret_val := settings_[nitem]
   if newvalue != NIL
      settings_[nitem] := newvalue
   endif
endif
return ret_val

// end function GInkeyTime()
*--------------------------------------------------------------------*

* eof inkey.prg
