/*
   Function:   Gilligan()
   Purpose:    Custom skipblock function for browsing arrays
   Called by:  ABROWSE(), APICK(), GRUMPCALC(), POPNOTE(), SETFILT()
   Author:     Greg Lief
   Copyright (c) 1991-3 Greg Lief
*/
function Gilligan(nEle, nSkipCnt, nMaxVal)
local nOldEle := nEle
// moved past bottom
if nEle + nSkipCnt > nMaxVal
   nEle := nMaxVal
// moved past top
elseif nEle + nSkipCnt < 1
   nEle := 1
else
   nEle += nSkipCnt
endif
return nEle - nOldEle

* end function Gilligan()
*--------------------------------------------------------------------*

// end of file GILLIGAN.PRG
